/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.attributes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;

public interface BoundableAttribute {
    public ElementChanges updateView(Component var1, ElementChanges var2);

    public void updateModel(Component var1, ValueChange var2);

    default public void updateBinding(ValueChange valueChange, ModelBinding modelBinding, Object binding) {
        this.updateBinding(valueChange, modelBinding, binding, Optional.empty());
    }

    default public void updateBinding(ValueChange valueChange, ModelBinding modelBinding, Object binding, Optional<String> formatter) {
        this.updateBinding(valueChange.getMainValue(), modelBinding, binding, formatter);
    }

    default public void updateBindingForValue(Object newValue, ModelBinding modelBinding, Object binding) {
        this.updateBinding(newValue, modelBinding, binding, Optional.empty());
    }

    default public void updateBinding(Object newValue, ModelBinding modelBinding, Object binding, Optional<String> formatter) {
        if (modelBinding != null) {
            if (modelBinding.canChange()) {
                modelBinding.setValue(newValue);
            } else {
                throw new FhBindingException("Can't change read only property '" + binding + "'. Usually this error occurs when  curly brackets '{}' are omitted !");
            }
        }
    }

    @JsonIgnore
    default public Optional<String> getOptionalFormatter() {
        return Optional.empty();
    }

    @JsonIgnore
    public ModelBinding getModelBinding();

    @JsonIgnore
    public void setModelBinding(ModelBinding var1);
}

