package tech.beepbeep.beep_loader

class LoaderUtils {
    companion object {
        private val hexArray = "0123456789ABCDEF".toCharArray()

        fun bytesToHex(bytes: ByteArray): String {
            val result = StringBuffer()

            for (j in bytes.indices) {
                val octet = bytes[j].toInt()
                val firstIndex = (octet and 0xF0).ushr(4)
                val secondIndex = octet and 0x0F
                result.append(hexArray[firstIndex])
                result.append(hexArray[secondIndex])
            }

            return result.toString()
        }
    }
}