/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.express;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.function.Consumer;
import tech.xigam.express.Request;
import tech.xigam.express.Route;
import tech.xigam.express.Router;

public final class Express {
    private final InetSocketAddress address;
    public Consumer<Request> notFound;
    private Router router;

    public Express(InetSocketAddress address) {
        this.address = address;
    }

    public static Express create(int port) {
        return new Express(new InetSocketAddress(port));
    }

    public static Express create(int port, String address) {
        return new Express(new InetSocketAddress(address, port));
    }

    public Express notFound(Consumer<Request> handler) {
        this.notFound = handler;
        return this;
    }

    public Express router(Router router) {
        this.router = router;
        return this;
    }

    public void listen() throws IOException {
        HttpServer httpServer = HttpServer.create(this.address, 0);
        for (Map.Entry<String, Consumer<Request>> routes : this.router.get.entrySet()) {
            httpServer.createContext(routes.getKey(), new Route(Route.RouteType.GET, routes.getValue(), this));
        }
        for (Map.Entry<String, Consumer<Request>> routes : this.router.post.entrySet()) {
            httpServer.createContext(routes.getKey(), new Route(Route.RouteType.POST, routes.getValue(), this));
        }
        for (Map.Entry<String, Consumer<Request>> routes : this.router.put.entrySet()) {
            httpServer.createContext(routes.getKey(), new Route(Route.RouteType.PUT, routes.getValue(), this));
        }
        for (Map.Entry<String, Consumer<Request>> routes : this.router.delete.entrySet()) {
            httpServer.createContext(routes.getKey(), new Route(Route.RouteType.DELETE, routes.getValue(), this));
        }
        for (Map.Entry<String, Consumer<Request>> routes : this.router.patch.entrySet()) {
            httpServer.createContext(routes.getKey(), new Route(Route.RouteType.PATCH, routes.getValue(), this));
        }
        httpServer.start();
    }
}

