/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.express;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import tech.xigam.express.Express;
import tech.xigam.express.Request;

public final class Route
implements HttpHandler {
    private final RouteType routeType;
    private final Consumer<Request> handler;
    private final Express express;

    public Route(RouteType routeType, Consumer<Request> handler, Express express) {
        this.routeType = routeType;
        this.handler = handler;
        this.express = express;
    }

    @Override
    public void handle(HttpExchange exchange) {
        String requestMethod = exchange.getRequestMethod();
        String requestUrl = exchange.getRequestURI().toString();
        String requestBody = this.readBody(exchange.getRequestBody());
        Map<String, String> requestArguments = this.parseArguments(requestUrl);
        Request request = new Request(exchange, requestMethod, requestUrl, requestBody, requestArguments);
        if (!requestMethod.matches(this.routeType.name())) {
            this.express.notFound.accept(request);
            return;
        }
        this.handler.accept(request);
    }

    private Map<String, String> parseArguments(String url) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        try {
            String args = url.split("\\?")[1];
            String[] argumentPairs = args.split("&");
            String[] fPair = args.split("=");
            arguments.put(fPair[0].strip(), URLDecoder.decode(fPair[1].strip(), StandardCharsets.UTF_8));
            for (String rawPair : argumentPairs) {
                String[] pair = rawPair.split("=");
                arguments.put(pair[0].strip(), URLDecoder.decode(pair[1].strip(), StandardCharsets.UTF_8));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return arguments;
    }

    private String readBody(InputStream inputStream) {
        try {
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            int result = bis.read();
            while (result != -1) {
                buf.write((byte)result);
                result = bis.read();
            }
            return buf.toString();
        }
        catch (Exception ignored) {
            return inputStream.toString();
        }
    }

    public static enum RouteType {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

