/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.express;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Request {
    public final HttpExchange httpExchange;
    public final String requestType;
    public final String requestUrl;
    public final String requestBody;
    public final Map<String, String> requestArguments;
    private int responseCode = 200;
    private Map<String, String[]> responseHeaders = new HashMap<String, String[]>();

    public Request(HttpExchange httpExchange, String requestType, String requestUrl, String requestBody, Map<String, String> requestArguments) {
        this.httpExchange = httpExchange;
        this.requestType = requestType;
        this.requestUrl = requestUrl;
        this.requestBody = requestBody;
        this.requestArguments = requestArguments;
        try {
            httpExchange.getRequestBody().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request code(int statusCode) {
        this.responseCode = statusCode;
        return this;
    }

    public Request addHeader(String name, String ... value) {
        this.responseHeaders.put(name, value);
        return this;
    }

    public void respond(String response) {
        try {
            byte[] responseBytes = response.getBytes();
            OutputStream output = this.httpExchange.getResponseBody();
            this.httpExchange.sendResponseHeaders(this.responseCode, responseBytes.length);
            output.write(responseBytes);
            output.flush();
            output.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public List<String> urlSegments() {
        ArrayList<String> initial = new ArrayList<String>(List.of(this.requestUrl.split("/")));
        initial.remove(0);
        initial.remove(1);
        return initial;
    }

    public String getArgument(String key) {
        return this.requestArguments.get(key);
    }

    public String getRequestBody() {
        return this.requestBody;
    }
}

