/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.VideoClip;
import video.api.client.api.models.VideoWatermark;

public class VideoCreationPayload
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public = true;
    public static final String SERIALIZED_NAME_PANORAMIC = "panoramic";
    @SerializedName(value="panoramic")
    private Boolean panoramic = false;
    public static final String SERIALIZED_NAME_MP4_SUPPORT = "mp4Support";
    @SerializedName(value="mp4Support")
    private Boolean mp4Support = true;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private String playerId;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private List<Metadata> metadata = null;
    public static final String SERIALIZED_NAME_CLIP = "clip";
    @SerializedName(value="clip")
    private VideoClip clip;
    public static final String SERIALIZED_NAME_WATERMARK = "watermark";
    @SerializedName(value="watermark")
    private VideoWatermark watermark;

    public VideoCreationPayload title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="Maths video", required=true, value="The title of your new video.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public VideoCreationPayload description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A video about string theory.", value="A brief description of your video.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VideoCreationPayload source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.myvideo.url.com/video.mp4 OR vi4k0jvEUuaTdRAEjQ4JfOyl", value="You can either add a video already on the web, by entering the URL of the video, or you can also enter the `videoId` of one of the videos you already have on your api.video acccount, and this will generate a copy of your video. Creating a copy of a video can be especially useful if you want to keep your original video and trim or apply a watermark onto the copy you would create.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public VideoCreationPayload _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether your video can be viewed by everyone, or requires authentication to see it. A setting of false will require a unique token for each view. Default is true. Tutorials on [private videos](https://api.video/blog/endpoints/private-videos).")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public VideoCreationPayload panoramic(Boolean panoramic) {
        this.panoramic = panoramic;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Indicates if your video is a 360/immersive video.")
    public Boolean getPanoramic() {
        return this.panoramic;
    }

    public void setPanoramic(Boolean panoramic) {
        this.panoramic = panoramic;
    }

    public VideoCreationPayload mp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Enables mp4 version in addition to streamed version.")
    public Boolean getMp4Support() {
        return this.mp4Support;
    }

    public void setMp4Support(Boolean mp4Support) {
        this.mp4Support = mp4Support;
    }

    public VideoCreationPayload playerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pl45KFKdlddgk654dspkze", value="The unique identification number for your video player.")
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public VideoCreationPayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public VideoCreationPayload addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"maths\", \"string theory\", \"video\"]", value="A list of tags you want to use to describe your video.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public VideoCreationPayload metadata(List<Metadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public VideoCreationPayload addMetadataItem(Metadata metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<Metadata>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"key\": \"Author\", \"value\": \"John Doe\"}]", value="A list of key value pairs that you use to provide metadata for your video. These pairs can be made dynamic, allowing you to segment your audience. Read more on [dynamic metadata](https://api.video/blog/endpoints/dynamic-metadata).")
    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    public VideoCreationPayload clip(VideoClip clip) {
        this.clip = clip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoClip getClip() {
        return this.clip;
    }

    public void setClip(VideoClip clip) {
        this.clip = clip;
    }

    public VideoCreationPayload watermark(VideoWatermark watermark) {
        this.watermark = watermark;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoWatermark getWatermark() {
        return this.watermark;
    }

    public void setWatermark(VideoWatermark watermark) {
        this.watermark = watermark;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoCreationPayload videoCreationPayload = (VideoCreationPayload)o;
        return Objects.equals(this.title, videoCreationPayload.title) && Objects.equals(this.description, videoCreationPayload.description) && Objects.equals(this.source, videoCreationPayload.source) && Objects.equals(this._public, videoCreationPayload._public) && Objects.equals(this.panoramic, videoCreationPayload.panoramic) && Objects.equals(this.mp4Support, videoCreationPayload.mp4Support) && Objects.equals(this.playerId, videoCreationPayload.playerId) && Objects.equals(this.tags, videoCreationPayload.tags) && Objects.equals(this.metadata, videoCreationPayload.metadata) && Objects.equals(this.clip, videoCreationPayload.clip) && Objects.equals(this.watermark, videoCreationPayload.watermark);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.source, this._public, this.panoramic, this.mp4Support, this.playerId, this.tags, this.metadata, this.clip, this.watermark);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoCreationPayload {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    panoramic: ").append(this.toIndentedString(this.panoramic)).append("\n");
        sb.append("    mp4Support: ").append(this.toIndentedString(this.mp4Support)).append("\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    clip: ").append(this.toIndentedString(this.clip)).append("\n");
        sb.append("    watermark: ").append(this.toIndentedString(this.watermark)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

