/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import video.api.client.api.models.PlayerThemeAssets;

public class PlayerTheme
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private String text;
    public static final String SERIALIZED_NAME_LINK = "link";
    @SerializedName(value="link")
    private String link;
    public static final String SERIALIZED_NAME_LINK_HOVER = "linkHover";
    @SerializedName(value="linkHover")
    private String linkHover;
    public static final String SERIALIZED_NAME_LINK_ACTIVE = "linkActive";
    @SerializedName(value="linkActive")
    private String linkActive;
    public static final String SERIALIZED_NAME_TRACK_PLAYED = "trackPlayed";
    @SerializedName(value="trackPlayed")
    private String trackPlayed;
    public static final String SERIALIZED_NAME_TRACK_UNPLAYED = "trackUnplayed";
    @SerializedName(value="trackUnplayed")
    private String trackUnplayed;
    public static final String SERIALIZED_NAME_TRACK_BACKGROUND = "trackBackground";
    @SerializedName(value="trackBackground")
    private String trackBackground;
    public static final String SERIALIZED_NAME_BACKGROUND_TOP = "backgroundTop";
    @SerializedName(value="backgroundTop")
    private String backgroundTop;
    public static final String SERIALIZED_NAME_BACKGROUND_BOTTOM = "backgroundBottom";
    @SerializedName(value="backgroundBottom")
    private String backgroundBottom;
    public static final String SERIALIZED_NAME_BACKGROUND_TEXT = "backgroundText";
    @SerializedName(value="backgroundText")
    private String backgroundText;
    public static final String SERIALIZED_NAME_ENABLE_API = "enableApi";
    @SerializedName(value="enableApi")
    private Boolean enableApi;
    public static final String SERIALIZED_NAME_ENABLE_CONTROLS = "enableControls";
    @SerializedName(value="enableControls")
    private Boolean enableControls;
    public static final String SERIALIZED_NAME_FORCE_AUTOPLAY = "forceAutoplay";
    @SerializedName(value="forceAutoplay")
    private Boolean forceAutoplay;
    public static final String SERIALIZED_NAME_HIDE_TITLE = "hideTitle";
    @SerializedName(value="hideTitle")
    private Boolean hideTitle;
    public static final String SERIALIZED_NAME_FORCE_LOOP = "forceLoop";
    @SerializedName(value="forceLoop")
    private Boolean forceLoop;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private String playerId;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_ASSETS = "assets";
    @SerializedName(value="assets")
    private PlayerThemeAssets assets;

    public PlayerTheme name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the player theme")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PlayerTheme text(String text) {
        this.text = text;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color for timer text. Default: rgba(255, 255, 255, 1)")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public PlayerTheme link(String link) {
        this.link = link;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color for all controls. Default: rgba(255, 255, 255, 1)")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public PlayerTheme linkHover(String linkHover) {
        this.linkHover = linkHover;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color for all controls when hovered. Default: rgba(255, 255, 255, 1)")
    public String getLinkHover() {
        return this.linkHover;
    }

    public void setLinkHover(String linkHover) {
        this.linkHover = linkHover;
    }

    public PlayerTheme linkActive(String linkActive) {
        this.linkActive = linkActive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color for the play button when hovered.")
    public String getLinkActive() {
        return this.linkActive;
    }

    public void setLinkActive(String linkActive) {
        this.linkActive = linkActive;
    }

    public PlayerTheme trackPlayed(String trackPlayed) {
        this.trackPlayed = trackPlayed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color playback bar: played content. Default: rgba(88, 131, 255, .95)")
    public String getTrackPlayed() {
        return this.trackPlayed;
    }

    public void setTrackPlayed(String trackPlayed) {
        this.trackPlayed = trackPlayed;
    }

    public PlayerTheme trackUnplayed(String trackUnplayed) {
        this.trackUnplayed = trackUnplayed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color playback bar: downloaded but unplayed (buffered) content. Default: rgba(255, 255, 255, .35)")
    public String getTrackUnplayed() {
        return this.trackUnplayed;
    }

    public void setTrackUnplayed(String trackUnplayed) {
        this.trackUnplayed = trackUnplayed;
    }

    public PlayerTheme trackBackground(String trackBackground) {
        this.trackBackground = trackBackground;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color playback bar: background. Default: rgba(255, 255, 255, .2)")
    public String getTrackBackground() {
        return this.trackBackground;
    }

    public void setTrackBackground(String trackBackground) {
        this.trackBackground = trackBackground;
    }

    public PlayerTheme backgroundTop(String backgroundTop) {
        this.backgroundTop = backgroundTop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color: top 50% of background. Default: rgba(0, 0, 0, .7)")
    public String getBackgroundTop() {
        return this.backgroundTop;
    }

    public void setBackgroundTop(String backgroundTop) {
        this.backgroundTop = backgroundTop;
    }

    public PlayerTheme backgroundBottom(String backgroundBottom) {
        this.backgroundBottom = backgroundBottom;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color: bottom 50% of background. Default: rgba(0, 0, 0, .7)")
    public String getBackgroundBottom() {
        return this.backgroundBottom;
    }

    public void setBackgroundBottom(String backgroundBottom) {
        this.backgroundBottom = backgroundBottom;
    }

    public PlayerTheme backgroundText(String backgroundText) {
        this.backgroundText = backgroundText;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RGBA color for title text. Default: rgba(255, 255, 255, 1)")
    public String getBackgroundText() {
        return this.backgroundText;
    }

    public void setBackgroundText(String backgroundText) {
        this.backgroundText = backgroundText;
    }

    public PlayerTheme enableApi(Boolean enableApi) {
        this.enableApi = enableApi;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="enable/disable player SDK access. Default: true")
    public Boolean getEnableApi() {
        return this.enableApi;
    }

    public void setEnableApi(Boolean enableApi) {
        this.enableApi = enableApi;
    }

    public PlayerTheme enableControls(Boolean enableControls) {
        this.enableControls = enableControls;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="enable/disable player controls. Default: true")
    public Boolean getEnableControls() {
        return this.enableControls;
    }

    public void setEnableControls(Boolean enableControls) {
        this.enableControls = enableControls;
    }

    public PlayerTheme forceAutoplay(Boolean forceAutoplay) {
        this.forceAutoplay = forceAutoplay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="enable/disable player autoplay. Default: false")
    public Boolean getForceAutoplay() {
        return this.forceAutoplay;
    }

    public void setForceAutoplay(Boolean forceAutoplay) {
        this.forceAutoplay = forceAutoplay;
    }

    public PlayerTheme hideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="enable/disable title. Default: false")
    public Boolean getHideTitle() {
        return this.hideTitle;
    }

    public void setHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public PlayerTheme forceLoop(Boolean forceLoop) {
        this.forceLoop = forceLoop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="enable/disable looping. Default: false")
    public Boolean getForceLoop() {
        return this.forceLoop;
    }

    public void setForceLoop(Boolean forceLoop) {
        this.forceLoop = forceLoop;
    }

    public PlayerTheme playerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @ApiModelProperty(example="pl45KFKdlddgk654dspkze", required=true, value="")
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public PlayerTheme createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-01-31T10:17:47Z", value="When the player was created, presented in ISO-8601 format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PlayerTheme updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-01-31T10:18:47Z", value="When the player was last updated, presented in ISO-8601 format.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PlayerTheme assets(PlayerThemeAssets assets) {
        this.assets = assets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlayerThemeAssets getAssets() {
        return this.assets;
    }

    public void setAssets(PlayerThemeAssets assets) {
        this.assets = assets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerTheme playerTheme = (PlayerTheme)o;
        return Objects.equals(this.name, playerTheme.name) && Objects.equals(this.text, playerTheme.text) && Objects.equals(this.link, playerTheme.link) && Objects.equals(this.linkHover, playerTheme.linkHover) && Objects.equals(this.linkActive, playerTheme.linkActive) && Objects.equals(this.trackPlayed, playerTheme.trackPlayed) && Objects.equals(this.trackUnplayed, playerTheme.trackUnplayed) && Objects.equals(this.trackBackground, playerTheme.trackBackground) && Objects.equals(this.backgroundTop, playerTheme.backgroundTop) && Objects.equals(this.backgroundBottom, playerTheme.backgroundBottom) && Objects.equals(this.backgroundText, playerTheme.backgroundText) && Objects.equals(this.enableApi, playerTheme.enableApi) && Objects.equals(this.enableControls, playerTheme.enableControls) && Objects.equals(this.forceAutoplay, playerTheme.forceAutoplay) && Objects.equals(this.hideTitle, playerTheme.hideTitle) && Objects.equals(this.forceLoop, playerTheme.forceLoop) && Objects.equals(this.playerId, playerTheme.playerId) && Objects.equals(this.createdAt, playerTheme.createdAt) && Objects.equals(this.updatedAt, playerTheme.updatedAt) && Objects.equals(this.assets, playerTheme.assets);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.text, this.link, this.linkHover, this.linkActive, this.trackPlayed, this.trackUnplayed, this.trackBackground, this.backgroundTop, this.backgroundBottom, this.backgroundText, this.enableApi, this.enableControls, this.forceAutoplay, this.hideTitle, this.forceLoop, this.playerId, this.createdAt, this.updatedAt, this.assets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlayerTheme {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    linkHover: ").append(this.toIndentedString(this.linkHover)).append("\n");
        sb.append("    linkActive: ").append(this.toIndentedString(this.linkActive)).append("\n");
        sb.append("    trackPlayed: ").append(this.toIndentedString(this.trackPlayed)).append("\n");
        sb.append("    trackUnplayed: ").append(this.toIndentedString(this.trackUnplayed)).append("\n");
        sb.append("    trackBackground: ").append(this.toIndentedString(this.trackBackground)).append("\n");
        sb.append("    backgroundTop: ").append(this.toIndentedString(this.backgroundTop)).append("\n");
        sb.append("    backgroundBottom: ").append(this.toIndentedString(this.backgroundBottom)).append("\n");
        sb.append("    backgroundText: ").append(this.toIndentedString(this.backgroundText)).append("\n");
        sb.append("    enableApi: ").append(this.toIndentedString(this.enableApi)).append("\n");
        sb.append("    enableControls: ").append(this.toIndentedString(this.enableControls)).append("\n");
        sb.append("    forceAutoplay: ").append(this.toIndentedString(this.forceAutoplay)).append("\n");
        sb.append("    hideTitle: ").append(this.toIndentedString(this.hideTitle)).append("\n");
        sb.append("    forceLoop: ").append(this.toIndentedString(this.forceLoop)).append("\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

