/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api;

import java.io.IOException;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.models.VideoUpdatePayload;

@DisplayName(value="VideosDelegatedUploadApi")
public class ApiClientTest {
    private String requestBodyToString(ApiClient apiClient, Object payload) throws IOException, ApiException {
        RequestBody requestBody = apiClient.serialize(payload, "application/json");
        Buffer buffer = new Buffer();
        requestBody.writeTo((BufferedSink)buffer);
        return buffer.toString();
    }

    @Test
    @DisplayName(value="required parameters")
    public void requiredParametersTest() throws ApiException, IOException {
        ApiClient apiClient = new ApiClient("path");
        VideoUpdatePayload videoUpdatePayload = new VideoUpdatePayload().title("title").playerId(null);
        Assertions.assertThat((String)this.requestBodyToString(apiClient, videoUpdatePayload)).isEqualTo("[text={\"playerId\":null,\"title\":\"title\"}]");
        videoUpdatePayload.unsetPlayerId();
        Assertions.assertThat((String)this.requestBodyToString(apiClient, videoUpdatePayload)).isEqualTo("[text={\"title\":\"title\"}]");
    }

    @Test
    public void applicationNameVerification() {
        ApiClient apiClient = new ApiClient("path");
        Assertions.assertThatThrownBy(() -> apiClient.setApplicationName(null, "0"));
        Assertions.assertThatThrownBy(() -> apiClient.setApplicationName("bad application name", "0"));
        Assertions.assertThatThrownBy(() -> apiClient.setApplicationName("012345678901234567890123456789012345678901234567890", "0"));
        apiClient.setApplicationName("great-application-name", "0");
        Assertions.assertThatThrownBy(() -> apiClient.setApplicationName("great-application-name", null));
        Assertions.assertThatThrownBy(() -> apiClient.setApplicationName("great-application-name", "aa"));
        apiClient.setApplicationName("great-application-name", "1.2.3");
    }
}

