/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.net.URI;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.TagsApi;
import video.api.client.api.models.ListTagsResponseData;
import video.api.client.api.models.Page;
import video.api.client.api.models.PaginationLink;

@DisplayName(value="TagsApi")
public class TagsApiTest
extends AbstractApiTest {
    private final TagsApi api;

    public TagsApiTest() {
        this.api = this.apiClientMock.tags();
    }

    @Nested
    @DisplayName(value="list")
    class listTags {
        private static final String PAYLOADS_PATH = "/payloads/tags/list/";

        listTags() {
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            TagsApiTest.this.answerOnAnyRequest(200, TagsApiTest.this.readResourceFile("/payloads/tags/list/responses/200.json"));
            Page res = TagsApiTest.this.api.list().execute();
            Assertions.assertThat((Integer)res.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)res.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)res.getCurrentPageItems()).isEqualTo(2);
            Assertions.assertThat((List)res.getLinks()).containsExactlyInAnyOrder((Object[])new PaginationLink[]{new PaginationLink().rel("self").uri(URI.create("/tags?currentPage=1&pageSize=25")), new PaginationLink().rel("first").uri(URI.create("/tags?currentPage=1&pageSize=25")), new PaginationLink().rel("last").uri(URI.create("/tags?currentPage=1&pageSize=25"))});
            Assertions.assertThat((List)res.getItems()).containsExactlyInAnyOrder((Object[])new ListTagsResponseData[]{new ListTagsResponseData().value("maths").videoCount(Integer.valueOf(33)), new ListTagsResponseData().value("tutorials").videoCount(Integer.valueOf(10))});
        }
    }
}

