/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.code.java.declaration.ClassBodyElement;
import br.com.objectos.code.java.declaration.PackageName;
import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.ImportSet;
import br.com.objectos.code.java.io.JavaFile;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.comuns.lang.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

abstract class TypeCode
extends AbstractCodeElement
implements ClassBodyElement {
    TypeCode() {
    }

    @Override
    public final BodyElement.Kind kind() {
        return BodyElement.Kind.TYPE;
    }

    public abstract String simpleName();

    public final JavaFile toJavaFile(PackageName packageName) {
        Preconditions.checkNotNull((Object)packageName, (String)"packageName == null");
        return new TypeCodeJavaFile(packageName, this);
    }

    private static class TypeCodeJavaFile
    implements JavaFile {
        private final PackageName packageName;
        private final TypeCode typeCode;

        TypeCodeJavaFile(PackageName packageName, TypeCode typeCode) {
            this.packageName = packageName;
            this.typeCode = typeCode;
        }

        @Override
        public final String toString() {
            ImportSet importSet = ImportSet.forPackageName(this.packageName);
            CodeWriter writer = CodeWriter.forJavaFile(importSet);
            this.typeCode.acceptCodeWriter(writer);
            return writer.toJavaFile();
        }

        @Override
        public final void writeTo(Filer filer) {
            try {
                this.writeTo0(filer);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void writeTo0(Filer filer) throws IOException {
            ClassName className = this.packageName.nestedClass(this.typeCode.simpleName());
            JavaFileObject object = filer.createSourceFile(className.toString(), new Element[0]);
            try (Writer writer = object.openWriter();){
                writer.write(this.toString());
            }
        }
    }
}

