/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.code.java.io.Formatting;
import br.com.objectos.code.java.io.FormattingAction;
import br.com.objectos.code.java.io.FormattingSource;
import br.com.objectos.code.java.io.TailFormattingAction;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import java.util.Iterator;

public abstract class BodyFormatter {
    private static final BodyFormatter DEFAULT = BodyFormatter.with(Formatting.newLine(), Formatting.fields(), Formatting.constructors(), Formatting.methods(), Formatting.types());
    private static final BodyFormatter UNFORMATED = new UnformattedClassBodyFormatter();

    BodyFormatter() {
    }

    public static BodyFormatter defaultFormatter() {
        return DEFAULT;
    }

    public static BodyFormatter unformatted() {
        return UNFORMATED;
    }

    public static BodyFormatter with(Formatting ... formattings) {
        return new StandardClassBodyFormatter(ImmutableList.newListWithAll((Object[])formattings));
    }

    public abstract <E extends BodyElement> ImmutableList<E> format(GrowableList<E> var1, Class<E> var2);

    private static class UnformattedClassBodyFormatter
    extends BodyFormatter {
        private UnformattedClassBodyFormatter() {
        }

        @Override
        public final <E extends BodyElement> ImmutableList<E> format(GrowableList<E> elements, Class<E> type) {
            return elements.toImmutableList();
        }
    }

    private static class StandardClassBodyFormatter
    extends BodyFormatter {
        private final ImmutableList<Formatting> formattings;

        private StandardClassBodyFormatter(ImmutableList<Formatting> formattings) {
            this.formattings = formattings;
        }

        @Override
        public final <E extends BodyElement> ImmutableList<E> format(GrowableList<E> elements, Class<E> type) {
            FormattingAction action = TailFormattingAction.getInstance();
            for (int i = this.formattings.size() - 1; i >= 0; --i) {
                Formatting formatting = (Formatting)this.formattings.get(i);
                action = formatting.newAction(action);
            }
            ThisFormattingSource source = new ThisFormattingSource(elements);
            ((FormattingAction)action).consume(source);
            return action.toImmutableList(type);
        }

        private static class ThisFormattingSource
        implements FormattingSource {
            private final Iterator<? extends BodyElement> elements;

            ThisFormattingSource(GrowableList<? extends BodyElement> elements) {
                this.elements = elements.iterator();
            }

            @Override
            public final BodyElement getElement() {
                return this.elements.next();
            }

            @Override
            public final boolean hasElements() {
                return this.elements.hasNext();
            }
        }
    }
}

