/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.PackageName;
import br.com.objectos.code.java.io.JavaFileImportSet;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;

public abstract class ImportSet {
    private static final ImportSet FOR_TO_STRING = new ForToStringImportSet();

    ImportSet() {
    }

    public static ImportSet forPackageName(PackageName packageName) {
        return new JavaFileImportSet(packageName);
    }

    static ImportSet forToString() {
        return FOR_TO_STRING;
    }

    public abstract boolean contains(ClassName var1);

    public abstract String get(TypeName var1);

    public abstract boolean isEmpty();

    public abstract int size();

    private static class ForToStringImportSet
    extends ImportSet {
        private ForToStringImportSet() {
        }

        @Override
        public final boolean contains(ClassName qualifiedName) {
            return false;
        }

        @Override
        public final String get(TypeName typeName) {
            return typeName.toString();
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final int size() {
            return 0;
        }
    }
}

