/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.ForStatement;
import br.com.objectos.code.java.statement.Statement;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.lang.Preconditions;

public class EnhancedForStatement
extends AbstractStatement
implements ForStatement {
    private final TypeName typeName;
    private final Identifier id;
    private final ExpressionCode expression;
    private final Statement statement;

    private EnhancedForStatement(TypeName typeName, Identifier id, ExpressionCode expression, Statement statement) {
        this.typeName = typeName;
        this.id = id;
        this.expression = expression;
        this.statement = statement;
    }

    static Builder builder(Class<?> type, Identifier id, ExpressionCode expression) {
        Preconditions.checkNotNull(type, (String)"type == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        ClassName className = ClassName.of(type);
        return new Builder(className, id, expression);
    }

    static Builder builder(TypeName typeName, Identifier id, ExpressionCode expression) {
        Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
        Preconditions.checkNotNull((Object)id, (String)"id == null");
        Preconditions.checkNotNull((Object)expression, (String)"expression == null");
        return new Builder(typeName, id, expression);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeWord("for").writeWord('(').spaceOff().writeTypeNameAsWord(this.typeName).writeWord(this.id.name()).writeWord(':').writeCodeElement(this.expression).spaceOff().writeWord(')').writeCodeElement(this.statement);
    }

    public static class Builder {
        private final TypeName typeName;
        private final Identifier id;
        private final ExpressionCode expression;

        private Builder(TypeName typeName, Identifier id, ExpressionCode expression) {
            this.typeName = typeName;
            this.id = id;
            this.expression = expression;
        }

        public final EnhancedForStatement block(BlockElement ... elements) {
            Block block = Block.of(elements);
            return new EnhancedForStatement(this.typeName, this.id, this.expression, block);
        }
    }
}

