/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.statement.StatementOrBlockBuilder;
import br.com.objectos.code.java.statement.Statements;

final class AssignmentImpl
    // extends AbstractForwarindCodeElement instead of
    // AbstractDefaultCodeElement since AssignmentExpression is on the top of
    // the Expression grammar
    extends AbstractForwardingCodeElement
    implements Assignment {

  private AssignmentImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static Assignment assign0(
      AssignmentOperator operator, LeftHandSide lhs, ExpressionCode rhs) {
    return new AssignmentImpl(
        ImmutableCodeElement.builder()
            .withCodeElement(lhs)
            .withCodeElement(operator)
            .withCodeElement(rhs)
            .build()
    );
  }

  @Override
  public final void acceptStatementOrBlockBuilder(StatementOrBlockBuilder builder) {
    builder.withStatement(this);
  }

  @Override
  public final String toString() {
    return Statements.toString(this);
  }

}
