/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.statement;

import static br.com.objectos.code.java.CodeJava.l;
import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.io.CodeWriter;

public class CaseSwitchElement extends AbstractCodeElement implements SwitchElement {

  private final CodeElement value;

  private CaseSwitchElement(CodeElement value) {
    this.value = value;
  }

  public static CaseSwitchElement _case(int value) {
    return CaseSwitchElement.ofUnchecked(value);
  }

  public static CaseSwitchElement _case(Identifier value) {
    checkNotNull(value, "value == null");
    return CaseSwitchElement.ofUnchecked(value);
  }

  public static CaseSwitchElement _case(String value) {
    checkNotNull(value, "value == null");
    return CaseSwitchElement.ofUnchecked(value);
  }

  static CaseSwitchElement ofUnchecked(int value) {
    return new CaseSwitchElement(l(value));
  }

  static CaseSwitchElement ofUnchecked(Identifier value) {
    return new CaseSwitchElement(value);
  }

  static CaseSwitchElement ofUnchecked(String value) {
    return new CaseSwitchElement(l(value));
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeWord("case").writeCodeElement(value).spaceOff().write(':');
  }

  public final SwitchElement body(BlockStatement... statements) {
    return SwitchGroup.of(this, statements);
  }

}
