/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.type;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import java.util.Iterator;

public interface ClassNameOrParameterizedTypeName extends ReferenceTypeName {

  static ClassNameOrParameterizedTypeName noType() {
    return NoTypeName._void();
  }

  default ArrayTypeName toArrayTypeName() {
    return ArrayTypeName.ofUnchecked(this);
  }

  default ParameterizedTypeName withTypeArgument(Class<?> type) {
    return withTypeArgument(ClassName.of(type));
  }

  default ParameterizedTypeName withTypeArgument(String name) {
    return withTypeArgument(TypeVariableName.named(name));
  }

  ParameterizedTypeName withTypeArgument(TypeName type);

  default ClassNameOrParameterizedTypeName withTypeArguments(
      Iterable<? extends TypeName> arguments) {
    checkNotNull(arguments, "arguments == null");
    return withTypeArguments(arguments.iterator());
  }

  default ClassNameOrParameterizedTypeName withTypeArguments(
      Iterator<? extends TypeName> arguments) {
    checkNotNull(arguments, "arguments == null");
    if (arguments.hasNext()) {
      ParameterizedTypeName result = withTypeArgument(arguments.next());
      while (arguments.hasNext()) {
        result = result.withTypeArgument(arguments.next());
      }
      return result;
    } else {
      return this;
    }
  }

}