/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.expression.CastExpression;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpressionNotPlusMinus;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.JavaFileImportSet;

public class NoTypeName implements ClassNameOrParameterizedTypeName {

  static final NoTypeName VOID = new NoTypeName();

  private NoTypeName() {}

  public static NoTypeName _void() {
    return VOID;
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w.writeTypeNameAsWord(this);
  }

  @Override
  public final String acceptJavaFileImportSet(JavaFileImportSet set) {
    return toString();
  }

  @Override
  public final <R, P> R acceptTypeNameVisitor(TypeNameVisitor<R, P> visitor, P p) {
    return visitor.visitNoTypeName(this, p);
  }

  @Override
  public final TypeName arrayCreationTypeName() {
    throw new UnsupportedOperationException();
  }

  @Override
  public final CastExpression cast(UnaryExpressionNotPlusMinus expression) {
    throw new UnsupportedOperationException();
  }

  @Override
  public final boolean isVoid() {
    return true;
  }

  @Override
  public final MethodReference ref(String methodName) {
    throw new UnsupportedOperationException();
  }

  @Override
  public final MethodReference ref(TypeWitness witness, String methodName) {
    throw new UnsupportedOperationException();
  }

  @Override
  public final String toString() {
    return "void";
  }

  @Override
  public final ParameterizedTypeName withTypeArgument(TypeName type) {
    throw new UnsupportedOperationException();
  }

}