/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.code.java.type.TypeNameFactory;
import br.com.objectos.code.java.type.TypeVariableName;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterable;
import br.com.objectos.comuns.lang.Preconditions;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

public abstract class TypeParameterName
extends AbstractCodeElement {
    TypeParameterName() {
    }

    public static TypeParameterName named(String name) {
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        return new Unbounded(name);
    }

    public static TypeParameterName of(TypeParameterElement element) {
        Preconditions.checkNotNull((Object)element, (String)"element == null");
        TypeParameterName name = TypeParameterName.named(element.getSimpleName().toString());
        List<? extends TypeMirror> bounds = element.getBounds();
        for (TypeMirror typeMirror : bounds) {
            TypeName typeName = TypeNameFactory.ofUnchecked(typeMirror);
            if (typeName.isJavaLangObject()) continue;
            name = name.addBound0(typeName);
        }
        return name;
    }

    public static ImmutableList<TypeParameterName> immutableListOf(TypeElement typeElement) {
        return TypeParameterName.streamIterableOf(typeElement).toImmutableList();
    }

    public static StreamIterable<TypeParameterName> streamIterableOf(TypeElement typeElement) {
        Preconditions.checkNotNull((Object)typeElement, (String)"typeElement == null");
        return StreamIterable.adapt(typeElement.getTypeParameters()).map(TypeParameterName::of);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.write(this.toString());
    }

    public final TypeParameterName addBound(Class<?> type) {
        return this.addBound0(ClassName.of(type));
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeParameterName)) {
            return false;
        }
        TypeParameterName that = (TypeParameterName)obj;
        return this.toString().equals(that.toString());
    }

    @Override
    public final int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public abstract String toString();

    public abstract TypeVariableName toTypeVariableName();

    abstract TypeParameterName addBound0(TypeName var1);

    private static class Bounded
    extends TypeParameterName {
        private final TypeParameterName previous;
        private final String separator;
        private final TypeName bound;

        Bounded(TypeParameterName previous, String separator, TypeName bound) {
            this.previous = previous;
            this.separator = separator;
            this.bound = bound;
        }

        static Bounded first(Unbounded unbounded, TypeName bound) {
            return new Bounded(unbounded, " extends ", bound);
        }

        @Override
        public final String toString() {
            return this.previous + this.separator + this.bound;
        }

        @Override
        public final TypeVariableName toTypeVariableName() {
            return this.previous.toTypeVariableName();
        }

        @Override
        final TypeParameterName addBound0(TypeName typeName) {
            return new Bounded(this, " & ", typeName);
        }
    }

    private static class Unbounded
    extends TypeParameterName {
        private final String name;

        Unbounded(String name) {
            this.name = name;
        }

        @Override
        public final String toString() {
            return this.name;
        }

        @Override
        public final TypeVariableName toTypeVariableName() {
            return TypeVariableName.named(this.name);
        }

        @Override
        final TypeParameterName addBound0(TypeName typeName) {
            return Bounded.first(this, typeName);
        }
    }
}

