/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.declaration;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ArrayTypeName;

public class VarArgs extends AbstractCodeElement implements ParameterTypeName {

  private final ArrayTypeName typeName;

  private VarArgs(ArrayTypeName typeName) {
    this.typeName = typeName;
  }

  public static VarArgs of(ArrayTypeName typeName) {
    checkNotNull(typeName, "typeName == null");
    return new VarArgs(typeName);
  }

  @Override
  public final CodeWriter acceptCodeWriter(CodeWriter w) {
    return w
        .writeTypeName(typeName.deepComponentTypeName())
        .writeWord(typeName.printVarArgsSymbol());
  }

  @Override
  public final boolean isVarArgs() {
    return true;
  }

}
