/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.element;

import static br.com.objectos.comuns.lang.Preconditions.checkNotNull;

import br.com.objectos.code.java.CodeJava;
import br.com.objectos.code.java.expression.Identifier;
import br.com.objectos.code.java.expression.PrimaryNoNewArray;
import br.com.objectos.code.java.statement.BreakStatement;
import br.com.objectos.code.java.statement.ContinueStatement;

public interface Keyword extends CodeElement {

  BreakKeyword BREAK = KeywordImpl.named("break");
  ContinueKeyword CONTINUE = KeywordImpl.named("continue");
  Keyword RETURN = KeywordImpl.named("return");
  ThisKeyword THIS = KeywordImpl.named("this");
  Keyword THROW = KeywordImpl.named("throw");

  interface BreakKeyword extends Keyword, BreakStatement {}

  interface ContinueKeyword extends Keyword, ContinueStatement {}

  interface ThisKeyword extends Keyword, PrimaryNoNewArray {

    static ThisKeyword _this() {
      return Keyword.THIS;
    }

    static Identifier _this(String name) {
      checkNotNull(name, "name == null");
      return CodeJava.id("this." + name);
    }

  }

}