/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.AbstractForwardingCodeElement;
import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.statement.VariableInitializer;

final class ArrayInitializerImpl extends AbstractForwardingCodeElement implements ArrayInitializer {

  static final ArrayInitializer EMPTY = new ArrayInitializerImpl(
      ImmutableCodeElement.builder()
          .withWord("{}")
          .build()
  );

  private ArrayInitializerImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ArrayInitializer a0(VariableInitializer... elements) {
    switch (elements.length) {
      case 0:
        return EMPTY;
      default:
        return new ArrayInitializerImpl(
            ImmutableCodeElement.builder()
                .withOpenBrace()
                .withSpaceOff()
                .withCommaSeparated(elements)
                .withSpaceOff()
                .withCloseBrace()
                .build()
        );
    }
  }

  static ArrayInitializer a0(Iterable<? extends VariableInitializer> elements) {
    return new ArrayInitializerImpl(
        ImmutableCodeElement.builder()
            .withOpenBrace()
            .withSpaceOff()
            .withCommaSeparated(elements)
            .withSpaceOff()
            .withCloseBrace()
            .build()
    );
  }

}
