/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.expression;

import br.com.objectos.code.java.element.ImmutableCodeElement;
import br.com.objectos.code.java.type.ClassName;

final class ClassInstanceCreationExpressionImpl
    extends AbstractDefaultStatementExpression
    implements ClassInstanceCreationExpression {

  private ClassInstanceCreationExpressionImpl(ImmutableCodeElement delegate) {
    super(delegate);
  }

  static ClassInstanceCreationExpression new0(
      ClassName className) {
    return new1(className, Arguments.empty());
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, Argument... args) {
    return new1(className, Arguments.of(args));
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, Iterable<? extends Argument> args) {
    return new1(className, Arguments.of(args));
  }

  private static ClassInstanceCreationExpression new1(
      ClassName className, Arguments args) {
    return new ClassInstanceCreationExpressionImpl(
        ImmutableCodeElement.builder()
            .withWord("new")
            .withTypeName(className)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, TypeWitness witness) {
    return new1(className, witness, Arguments.empty());
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, TypeWitness witness, Argument... args) {
    return new1(className, witness, Arguments.of(args));
  }

  static ClassInstanceCreationExpression new0(
      ClassName className, TypeWitness witness, Iterable<? extends Argument> args) {
    return new1(className, witness, Arguments.of(args));
  }

  private static ClassInstanceCreationExpression new1(
      ClassName className, TypeWitness witness, Arguments args) {
    return new ClassInstanceCreationExpressionImpl(
        ImmutableCodeElement.builder()
            .withWord("new")
            .withTypeName(className)
            .withSpaceOff()
            .withCodeElement(witness)
            .withSpaceOff()
            .withCodeElement(args)
            .build()
    );
  }

  @Override
  public final FieldAccess id(Identifier id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  public final FieldAccess id(String id) {
    return Expressions.fieldAccess(this, id);
  }

  @Override
  protected final ArrayReferenceExpression selfArrayReferenceExpression() {
    throw newUoe(ClassInstanceCreationExpression.class);
  }

  @Override
  protected final Callee selfCallee() {
    return this;
  }

  @Override
  protected final ConditionalAndExpression selfConditionalAndExpression() {
    return this;
  }

  @Override
  protected final LeftHandSide selfLeftHandSide() {
    throw newUoe(ClassInstanceCreationExpression.class);
  }

  @Override
  protected final MethodReferenceReferenceExpression selfMethodReferenceReferenceExpression() {
    return this;
  }

  @Override
  protected final MultiplicativeExpression selfMultiplicativeExpression() {
    return this;
  }

  @Override
  protected final PostfixExpression selfPostfixExpression() {
    return this;
  }

  @Override
  protected final RelationalExpression selfRelationalExpression() {
    return this;
  }

}
