/*
 * Copyright (C) 2014-2019 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.type.WildcardTypeName.Extends;
import br.com.objectos.code.java.type.WildcardTypeName.Super;
import br.com.objectos.code.java.type.WildcardTypeName.Unbounded;

public class SimpleTypeNameVisitor<R, P> implements TypeNameVisitor<R, P> {

  protected final R defaultValue;

  protected SimpleTypeNameVisitor() {
    this(null);
  }

  protected SimpleTypeNameVisitor(R defaultValue) {
    this.defaultValue = defaultValue;
  }

  @Override
  public R visitArrayTypeName(ArrayTypeName t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitClassName(ClassName t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitNoTypeName(NoTypeName t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitParameterizedTypeName(ParameterizedTypeName t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitPrimitiveType(PrimitiveTypeName t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitTypeVariableName(TypeVariableName t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitWildcardTypeNameExtends(Extends t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitWildcardTypeNameSuper(Super t, P p) {
    return defaultAction(t, p);
  }

  @Override
  public R visitWildcardTypeNameUnbounded(Unbounded t, P p) {
    return defaultAction(t, p);
  }

  protected R defaultAction(TypeName t, P p) {
    return defaultValue;
  }

}