/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sql.code;

import br.com.objectos.sql.code.ColumnCode;
import br.com.objectos.sql.code.ColumnCodeAnnotation;
import br.com.objectos.sql.code.ColumnCodeField;
import br.com.objectos.sql.code.ColumnCodeInner;
import br.com.objectos.sql.code.ColumnCodeMethod;
import br.com.objectos.sql.core.ColumnInfo;
import br.com.objectos.sql.core.ColumnInfoMap;
import br.com.objectos.sql.core.HasTableInfo;
import br.com.objectos.sql.core.TableInfo;
import br.com.objectos.sql.core.annotation.Table;
import br.com.objectos.way.code.CodeCanvasArtifact;
import br.com.objectos.way.code.CodeCanvasWriter;
import br.com.objectos.way.code.MethodInfo;
import br.com.objectos.way.code.SimpleTypeInfo;
import br.com.objectos.way.code.TypeInfo;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;

public class TableCode {
    private final TypeInfo typeInfo;
    private final MethodInfo methodInfo;
    private final TableInfo tableInfo;
    private final ClassName moduleClassName;
    private final ClassName tableClassName;
    private final List<ColumnCode> columnCodeList;

    private TableCode(TypeInfo typeInfo, MethodInfo methodInfo, TableInfo tableInfo, ClassName moduleClassName, ClassName tableClassName, List<ColumnCode> columnCodeList) {
        this.typeInfo = typeInfo;
        this.methodInfo = methodInfo;
        this.tableInfo = tableInfo;
        this.moduleClassName = moduleClassName;
        this.tableClassName = tableClassName;
        this.columnCodeList = columnCodeList;
    }

    public static TableCode code(TypeInfo typeInfo, MethodInfo methodInfo, TableInfo tableInfo) {
        ClassName moduleClassName = typeInfo.toClassNamePrefix("___");
        final ClassName tableClassName = moduleClassName.peerClass(tableInfo.getClassName());
        List columnCodeList = tableInfo.transformColumnList((Function)new Function<ColumnInfo, ColumnCode>(){

            public ColumnCode apply(ColumnInfo columnInfo) {
                return ColumnCode.code(tableClassName, columnInfo);
            }
        });
        return new TableCode(typeInfo, methodInfo, tableInfo, moduleClassName, tableClassName, columnCodeList);
    }

    public boolean isValid() {
        SimpleTypeInfo returnTypeInfo = this.methodInfo.returnTypeInfo();
        if (!returnTypeInfo.isInfoOf(TableInfo.class)) {
            this.methodInfo.compilationError("Method must return a TableInfo instance.");
            return false;
        }
        if (!this.methodInfo.hasParameterInfoListSize(0)) {
            this.methodInfo.compilationError("Method must have zero arguments.");
            return false;
        }
        return true;
    }

    public CodeCanvasArtifact toCodeCanvasArtifact() {
        TypeSpec typeSpec = this.type();
        JavaFile javaFile = this.typeInfo.toJavaFile(typeSpec);
        return CodeCanvasWriter.forJavaFile((JavaFile)javaFile).named(this.tableClassName).toCodeCanvasArtifact();
    }

    public FieldSpec toSqlModuleFieldSpec() {
        String varName = this.typeInfo.getVarName();
        return FieldSpec.builder(TableInfo.class, (String)this.methodInfo.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L.$L()", new Object[]{varName, this.methodInfo.name()}).build();
    }

    public String schemaName() {
        return this.tableInfo.getSchemaName();
    }

    MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    List<FieldSpec> staticField() {
        return ImmutableList.builder().add((Object)this.staticField0()).add((Object)this.staticField1()).add((Object)this.staticField2()).build();
    }

    MethodSpec staticMethod() {
        return MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.tableClassName).addStatement("return INSTANCE", new Object[0]).build();
    }

    TypeSpec type() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)this.tableInfo.getClassName()).addAnnotation(this.generatedAnnotationSpec()).addAnnotation(this.tableAnnotationSpec()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(HasTableInfo.class);
        type.addFields(this.staticField());
        type.addFields((Collection)Lists.transform(this.columnCodeList, ColumnCodeField.get()));
        type.addMethod(this.constructor());
        type.addMethod(this.staticMethod());
        type.addMethods((Collection)Lists.transform(this.columnCodeList, ColumnCodeMethod.get()));
        type.addMethod(this.tableInfoMethod());
        type.addTypes((Collection)Lists.transform(this.columnCodeList, ColumnCodeAnnotation.get()));
        type.addTypes((Collection)Lists.transform(this.columnCodeList, ColumnCodeInner.get()));
        return type.build();
    }

    private AnnotationSpec generatedAnnotationSpec() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"br.com.objectos.sql.compiler.SqlModuleProcessor"}).build();
    }

    private FieldSpec staticField0() {
        return FieldSpec.builder((TypeName)this.tableClassName, (String)"INSTANCE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{this.tableClassName}).build();
    }

    private FieldSpec staticField1() {
        return FieldSpec.builder(TableInfo.class, (String)"TABLE", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.$L", new Object[]{this.moduleClassName, this.methodInfo.name()}).build();
    }

    private FieldSpec staticField2() {
        return FieldSpec.builder(ColumnInfoMap.class, (String)"COLUMN_INFO_MAP", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("TABLE.toColumnInfoMap()", new Object[0]).build();
    }

    private AnnotationSpec tableAnnotationSpec() {
        return AnnotationSpec.builder(Table.class).addMember("name", "\"" + this.tableInfo.name() + "\"", new Object[0]).build();
    }

    private MethodSpec tableInfoMethod() {
        return MethodSpec.methodBuilder((String)"tableInfo").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TableInfo.class).addStatement("return TABLE", new Object[0]).build();
    }
}

