/*
 * Decompiled with CFR 0.152.
 */
package cn.openjava.basic.format.aspect;

import cn.openjava.basic.crypto.properties.CryptoProperties;
import cn.openjava.basic.format.annotation.EncryptResult;
import cn.openjava.basic.format.message.SystemMessage;
import cn.openjava.basic.format.utils.ResultCryptoUtil;
import cn.openjava.basic.format.vo.Result;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EncryptResultAspect {
    @Autowired
    private CryptoProperties cryptoProperties;

    @Around(value="@annotation(cn.openjava.basic.format.annotation.EncryptResult)")
    public Object doAround(ProceedingJoinPoint joinPoint) {
        try {
            EncryptResult encryptResult = this.getEncryptResult((JoinPoint)joinPoint);
            Object res = joinPoint.proceed();
            if (encryptResult == null || !this.cryptoProperties.isEnable()) {
                return res;
            }
            if (this.cryptoProperties.getCryptoType() == null) {
                return ResultCryptoUtil.encryptResult((Result)res, encryptResult.type());
            }
            return ResultCryptoUtil.encryptResult((Result)res, this.cryptoProperties.getCryptoType());
        }
        catch (Throwable throwable) {
            return Result.warning(SystemMessage.EXCEPTION);
        }
    }

    private EncryptResult getEncryptResult(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        return method.getAnnotation(EncryptResult.class);
    }
}

