/*
 * Decompiled with CFR 0.152.
 */
package com.botbye.model;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;

public class BotbyeConfig
implements Serializable {
    private static final String MODULE_VERSION = "0.0.1";
    private static final String MODULE_NAME = "Java";
    private String botbyeEndpoint = "https://verify.botbye.com";
    private String serverKey = "";
    private String path = "/validate-request/v2";
    private MediaType contentType;
    private Duration readTimeout = Duration.ofSeconds(2L);
    private Duration writeTimeout = Duration.ofSeconds(2L);
    private Duration connectionTimeout = Duration.ofSeconds(2L);
    private Duration callTimeout = Duration.ofSeconds(5L);
    private int maxIdleConnections = 250;
    private long keepAliveDuration = 5L;
    private TimeUnit keepAliveDurationTimeUnit = TimeUnit.MINUTES;
    private int maxRequestsPerHost = 1500;
    private int maxRequests = 1500;

    public BotbyeConfig() {
        this.contentType = MediaType.parse((String)"application/json");
    }

    public static String getModuleName() {
        return MODULE_NAME;
    }

    public static String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getBotbyeEndpoint() {
        return this.botbyeEndpoint;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public String getPath() {
        return this.path;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getCallTimeout() {
        return this.callTimeout;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public TimeUnit getKeepAliveDurationTimeUnit() {
        return this.keepAliveDurationTimeUnit;
    }

    public int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BotbyeConfig that = (BotbyeConfig)o;
        return this.maxIdleConnections == that.maxIdleConnections && this.keepAliveDuration == that.keepAliveDuration && this.maxRequestsPerHost == that.maxRequestsPerHost && this.maxRequests == that.maxRequests && Objects.equals(this.botbyeEndpoint, that.botbyeEndpoint) && Objects.equals(this.serverKey, that.serverKey) && Objects.equals(this.path, that.path) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.writeTimeout, that.writeTimeout) && Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.callTimeout, that.callTimeout) && this.keepAliveDurationTimeUnit == that.keepAliveDurationTimeUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.botbyeEndpoint, this.serverKey, this.path, this.contentType, this.readTimeout, this.writeTimeout, this.connectionTimeout, this.callTimeout, this.maxIdleConnections, this.keepAliveDuration, this.keepAliveDurationTimeUnit, this.maxRequestsPerHost, this.maxRequests});
    }

    public String toString() {
        return "BotbyeConfig{botbyeEndpoint='" + this.botbyeEndpoint + "', serverKey='" + this.serverKey + "', path='" + this.path + "', contentType=" + String.valueOf(this.contentType) + ", readTimeout=" + String.valueOf(this.readTimeout) + ", writeTimeout=" + String.valueOf(this.writeTimeout) + ", connectionTimeout=" + String.valueOf(this.connectionTimeout) + ", callTimeout=" + String.valueOf(this.callTimeout) + ", maxIdleConnections=" + this.maxIdleConnections + ", keepAliveDuration=" + this.keepAliveDuration + ", keepAliveDurationTimeUnit=" + String.valueOf((Object)this.keepAliveDurationTimeUnit) + ", maxRequestsPerHost=" + this.maxRequestsPerHost + ", maxRequests=" + this.maxRequests + "}";
    }

    public static class Builder {
        private String botbyeEndpoint = "https://verify.botbye.com";
        private String serverKey = "";
        private String path = "/validate-request/v2";
        private Duration readTimeout = Duration.ofSeconds(2L);
        private Duration writeTimeout = Duration.ofSeconds(2L);
        private Duration connectionTimeout = Duration.ofSeconds(2L);
        private Duration callTimeout = Duration.ofSeconds(5L);
        private int maxIdleConnections = 250;
        private long keepAliveDuration = 5L;
        private TimeUnit keepAliveDurationTimeUnit = TimeUnit.MINUTES;
        private int maxRequestsPerHost = 1500;
        private int maxRequests = 1500;
        private MediaType contentType = MediaType.parse((String)"application/json");

        public Builder botbyeEndpoint(String botbyeEndpoint) {
            this.botbyeEndpoint = botbyeEndpoint;
            return this;
        }

        public Builder serverKey(String serverKey) {
            this.serverKey = serverKey;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public Builder maxIdleConnections(int maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public Builder keepAliveDuration(long keepAliveDuration, TimeUnit unit) {
            this.keepAliveDuration = keepAliveDuration;
            this.keepAliveDurationTimeUnit = unit;
            return this;
        }

        public Builder maxRequestsPerHost(int maxRequestsPerHost) {
            this.maxRequestsPerHost = maxRequestsPerHost;
            return this;
        }

        public Builder maxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        public Builder contentType(MediaType contentType) {
            this.contentType = contentType;
            return this;
        }

        public BotbyeConfig build() {
            BotbyeConfig config = new BotbyeConfig();
            config.botbyeEndpoint = this.botbyeEndpoint;
            config.serverKey = this.serverKey;
            config.path = this.path;
            config.readTimeout = this.readTimeout;
            config.writeTimeout = this.writeTimeout;
            config.connectionTimeout = this.connectionTimeout;
            config.callTimeout = this.callTimeout;
            config.maxIdleConnections = this.maxIdleConnections;
            config.keepAliveDuration = this.keepAliveDuration;
            config.keepAliveDurationTimeUnit = this.keepAliveDurationTimeUnit;
            config.maxRequestsPerHost = this.maxRequestsPerHost;
            config.maxRequests = this.maxRequests;
            config.contentType = this.contentType;
            return config;
        }
    }
}

