/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DeepEquals {
    public static final String IGNORE_CUSTOM_EQUALS = "ignoreCustomEquals";
    public static final String ALLOW_STRINGS_TO_MATCH_NUMBERS = "stringsCanMatchNumbers";
    public static final String DIFF = "diff";
    private static final String EMPTY = "\u2205";
    private static final String TRIANGLE_ARROW = "\u25b6";
    private static final String ARROW = "\u21e8";
    private static final String ANGLE_LEFT = "\u300a";
    private static final String ANGLE_RIGHT = "\u300b";
    private static final double SCALE_DOUBLE = Math.pow(10.0, 10.0);
    private static final float SCALE_FLOAT = (float)Math.pow(10.0, 5.0);
    private static final ThreadLocal<Set<Object>> formattingStack = ThreadLocal.withInitial(() -> Collections.newSetFromMap(new IdentityHashMap()));
    private static final double doubleEpsilon = 1.0E-15;

    public static boolean deepEquals(Object a, Object b) {
        return DeepEquals.deepEquals(a, b, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deepEquals(Object a, Object b, Map<String, ?> options) {
        try {
            HashSet<Object> visited = new HashSet<Object>();
            boolean bl = DeepEquals.deepEquals(a, b, options, visited);
            return bl;
        }
        finally {
            formattingStack.remove();
        }
    }

    private static boolean deepEquals(Object a, Object b, Map<String, ?> options, Set<Object> visited) {
        LinkedList<ItemsToCompare> stack = new LinkedList<ItemsToCompare>();
        boolean result = DeepEquals.deepEquals(a, b, stack, options, visited);
        boolean isRecurive = Objects.equals(true, options.get("recursive_call"));
        if (!result && !stack.isEmpty()) {
            ItemsToCompare top = (ItemsToCompare)stack.peek();
            String breadcrumb = DeepEquals.generateBreadcrumb(stack);
            options.put(DIFF, breadcrumb);
            options.put("diff_item", top);
        }
        return result;
    }

    private static boolean deepEquals(Object a, Object b, Deque<ItemsToCompare> stack, Map<String, ?> options, Set<Object> visited) {
        Collection ignoreCustomEquals = (Collection)options.get(IGNORE_CUSTOM_EQUALS);
        boolean allowAllCustomEquals = ignoreCustomEquals == null;
        boolean hasNonEmptyIgnoreSet = ignoreCustomEquals != null && !ignoreCustomEquals.isEmpty();
        boolean allowStringsToMatchNumbers = Converter.convert2boolean(options.get(ALLOW_STRINGS_TO_MATCH_NUMBERS));
        stack.addFirst(new ItemsToCompare(a, b));
        while (!stack.isEmpty()) {
            Object key2;
            ItemsToCompare itemsToCompare = stack.peek();
            if (visited.contains(itemsToCompare)) {
                stack.removeFirst();
                continue;
            }
            visited.add(itemsToCompare);
            Object key1 = itemsToCompare._key1;
            if (key1 == (key2 = itemsToCompare._key2)) continue;
            if (key1 == null || key2 == null) {
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.VALUE_MISMATCH));
                return false;
            }
            if (key1 instanceof Number && key2 instanceof Number) {
                if (DeepEquals.compareNumbers((Number)key1, (Number)key2)) continue;
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.VALUE_MISMATCH));
                return false;
            }
            if (allowStringsToMatchNumbers && (key1 instanceof String && key2 instanceof Number || key1 instanceof Number && key2 instanceof String)) {
                try {
                    if (key1 instanceof String ? DeepEquals.compareNumbers(Converter.convert2BigDecimal(key1), (Number)key2) : DeepEquals.compareNumbers((Number)key1, Converter.convert2BigDecimal(key2))) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.VALUE_MISMATCH));
                return false;
            }
            if (key1 instanceof AtomicBoolean && key2 instanceof AtomicBoolean) {
                if (DeepEquals.compareAtomicBoolean((AtomicBoolean)key1, (AtomicBoolean)key2)) continue;
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.VALUE_MISMATCH));
                return false;
            }
            Class<?> key1Class = key1.getClass();
            Class<?> key2Class = key2.getClass();
            if (Converter.isSimpleTypeConversionSupported(key1Class, key1Class)) {
                if (key1 instanceof Comparable && key2 instanceof Comparable) {
                    try {
                        if (((Comparable)key1).compareTo(key2) == 0) continue;
                        stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.VALUE_MISMATCH));
                        return false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (key1.equals(key2)) continue;
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.VALUE_MISMATCH));
                return false;
            }
            if (key1 instanceof List) {
                if (!(key2 instanceof Collection)) {
                    stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.TYPE_MISMATCH));
                    return false;
                }
                if (DeepEquals.decomposeOrderedCollection((Collection)key1, (Collection)key2, stack)) continue;
                ItemsToCompare prior = stack.peek();
                stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                return false;
            }
            if (key1 instanceof Collection) {
                if (!(key2 instanceof Collection)) {
                    stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.COLLECTION_TYPE_MISMATCH));
                    return false;
                }
                if (DeepEquals.decomposeUnorderedCollection((Collection)key1, (Collection)key2, stack)) continue;
                ItemsToCompare prior = stack.peek();
                stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                return false;
            }
            if (key2 instanceof Collection) {
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.COLLECTION_TYPE_MISMATCH));
                return false;
            }
            if (key1 instanceof Map) {
                if (!(key2 instanceof Map)) {
                    stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.TYPE_MISMATCH));
                    return false;
                }
                if (DeepEquals.decomposeMap((Map)key1, (Map)key2, stack, options, visited)) continue;
                ItemsToCompare prior = stack.peek();
                stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                return false;
            }
            if (key2 instanceof Map) {
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.TYPE_MISMATCH));
                return false;
            }
            if (key1Class.isArray()) {
                if (!key2Class.isArray()) {
                    stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.TYPE_MISMATCH));
                    return false;
                }
                if (DeepEquals.decomposeArray(key1, key2, stack)) continue;
                ItemsToCompare prior = stack.peek();
                stack.addFirst(new ItemsToCompare(prior._key1, prior._key2, prior, Difference.VALUE_MISMATCH));
                return false;
            }
            if (key2Class.isArray()) {
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.TYPE_MISMATCH));
                return false;
            }
            if (!key1Class.equals(key2Class)) {
                stack.addFirst(new ItemsToCompare(key1, key2, stack.peek(), Difference.TYPE_MISMATCH));
                return false;
            }
            if (DeepEquals.hasCustomEquals(key1Class)) {
                boolean useCustomEqualsForThisClass;
                boolean bl = useCustomEqualsForThisClass = hasNonEmptyIgnoreSet && !ignoreCustomEquals.contains(key1Class);
                if (allowAllCustomEquals || useCustomEqualsForThisClass) {
                    if (key1.equals(key2)) continue;
                    HashMap newOptions = new HashMap(options);
                    newOptions.put("recursive_call", true);
                    HashSet ignoreSet = new HashSet();
                    if (ignoreCustomEquals != null) {
                        ignoreSet.addAll(ignoreCustomEquals);
                    }
                    ignoreSet.add(key1Class);
                    newOptions.put(IGNORE_CUSTOM_EQUALS, ignoreSet);
                    DeepEquals.deepEquals(key1, key2, newOptions);
                    ItemsToCompare diff = (ItemsToCompare)newOptions.get("diff_item");
                    if (diff != null) {
                        stack.addFirst(diff);
                    }
                    return false;
                }
            }
            DeepEquals.decomposeObject(key1, key2, stack);
        }
        return true;
    }

    private static boolean decomposeUnorderedCollection(Collection<?> col1, Collection<?> col2, Deque<ItemsToCompare> stack) {
        ItemsToCompare currentItem = stack.peek();
        if (col1.size() != col2.size()) {
            stack.addFirst(new ItemsToCompare(col1, col2, currentItem, Difference.COLLECTION_SIZE_MISMATCH));
            return false;
        }
        HashMap<Integer, List> hashGroups = new HashMap<Integer, List>();
        for (Object o : col2) {
            int hash = DeepEquals.deepHashCode(o);
            hashGroups.computeIfAbsent(hash, k -> new ArrayList()).add(o);
        }
        for (Object item1 : col1) {
            int hash1 = DeepEquals.deepHashCode(item1);
            List candidates = (List)hashGroups.get(hash1);
            if (candidates == null || candidates.isEmpty()) {
                stack.addFirst(new ItemsToCompare(item1, null, currentItem, Difference.COLLECTION_MISSING_ELEMENT));
                return false;
            }
            boolean foundMatch = false;
            for (Object item2 : candidates) {
                if (!DeepEquals.deepEquals(item1, item2)) continue;
                foundMatch = true;
                candidates.remove(item2);
                if (!candidates.isEmpty()) break;
                hashGroups.remove(hash1);
                break;
            }
            if (foundMatch) continue;
            stack.addFirst(new ItemsToCompare(item1, null, currentItem, Difference.COLLECTION_MISSING_ELEMENT));
            return false;
        }
        return true;
    }

    private static boolean decomposeOrderedCollection(Collection<?> col1, Collection<?> col2, Deque<ItemsToCompare> stack) {
        ItemsToCompare currentItem = stack.peek();
        if (col1.size() != col2.size()) {
            stack.addFirst(new ItemsToCompare(col1, col2, currentItem, Difference.COLLECTION_SIZE_MISMATCH));
            return false;
        }
        Iterator<?> i1 = col1.iterator();
        Iterator<?> i2 = col2.iterator();
        int index = 0;
        while (i1.hasNext()) {
            Object item1 = i1.next();
            Object item2 = i2.next();
            stack.addFirst(new ItemsToCompare(item1, item2, new int[]{index++}, currentItem, Difference.COLLECTION_ELEMENT_MISMATCH));
        }
        return true;
    }

    private static boolean decomposeMap(Map<?, ?> map1, Map<?, ?> map2, Deque<ItemsToCompare> stack, Map<String, ?> options, Set<Object> visited) {
        ItemsToCompare currentItem = stack.peek();
        if (map1.size() != map2.size()) {
            stack.addFirst(new ItemsToCompare(map1, map2, currentItem, Difference.MAP_SIZE_MISMATCH));
            return false;
        }
        HashMap<Integer, Collection> fastLookup = new HashMap<Integer, Collection>();
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            int hash = DeepEquals.deepHashCode(entry.getKey());
            fastLookup.computeIfAbsent(hash, k -> new ArrayList()).add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<?, ?> entry : map1.entrySet()) {
            Collection otherEntries = (Collection)fastLookup.get(DeepEquals.deepHashCode(entry.getKey()));
            if (otherEntries == null || otherEntries.isEmpty()) {
                stack.addFirst(new ItemsToCompare(entry.getKey(), null, currentItem, Difference.MAP_MISSING_KEY));
                return false;
            }
            boolean foundMatch = false;
            Iterator iterator = otherEntries.iterator();
            while (iterator.hasNext()) {
                Map.Entry otherEntry = (Map.Entry)iterator.next();
                if (!DeepEquals.deepEquals(entry.getKey(), otherEntry.getKey(), options, visited)) continue;
                stack.addFirst(new ItemsToCompare(entry.getValue(), otherEntry.getValue(), entry.getKey(), currentItem, true, Difference.MAP_VALUE_MISMATCH));
                iterator.remove();
                if (otherEntries.isEmpty()) {
                    fastLookup.remove(DeepEquals.deepHashCode(entry.getKey()));
                }
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            stack.addFirst(new ItemsToCompare(entry.getKey(), null, currentItem, Difference.MAP_MISSING_KEY));
            return false;
        }
        return true;
    }

    private static boolean decomposeArray(Object array1, Object array2, Deque<ItemsToCompare> stack) {
        int len2;
        ItemsToCompare currentItem = stack.peek();
        Class<?> type1 = array1.getClass();
        Class<?> type2 = array2.getClass();
        int dim1 = 0;
        int dim2 = 0;
        while (type1.isArray()) {
            ++dim1;
            type1 = type1.getComponentType();
        }
        while (type2.isArray()) {
            ++dim2;
            type2 = type2.getComponentType();
        }
        if (dim1 != dim2) {
            stack.addFirst(new ItemsToCompare(array1, array2, currentItem, Difference.ARRAY_DIMENSION_MISMATCH));
            return false;
        }
        if (!array1.getClass().getComponentType().equals(array2.getClass().getComponentType())) {
            stack.addFirst(new ItemsToCompare(array1, array2, currentItem, Difference.ARRAY_COMPONENT_TYPE_MISMATCH));
            return false;
        }
        int len1 = Array.getLength(array1);
        if (len1 != (len2 = Array.getLength(array2))) {
            stack.addFirst(new ItemsToCompare(array1, array2, currentItem, Difference.ARRAY_LENGTH_MISMATCH));
            return false;
        }
        for (int i = len1 - 1; i >= 0; --i) {
            stack.addFirst(new ItemsToCompare(Array.get(array1, i), Array.get(array2, i), new int[]{i}, currentItem, Difference.ARRAY_ELEMENT_MISMATCH));
        }
        return true;
    }

    private static boolean decomposeObject(Object obj1, Object obj2, Deque<ItemsToCompare> stack) {
        ItemsToCompare currentItem = stack.peek();
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(obj1.getClass());
        for (Field field : fields) {
            try {
                if (field.isSynthetic()) continue;
                Object value1 = field.get(obj1);
                Object value2 = field.get(obj2);
                stack.addFirst(new ItemsToCompare(value1, value2, field.getName(), currentItem, Difference.FIELD_VALUE_MISMATCH));
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private static boolean compareNumbers(Number a, Number b) {
        if (a instanceof Float || a instanceof Double || b instanceof Float || b instanceof Double) {
            if (a instanceof BigDecimal || b instanceof BigDecimal) {
                try {
                    BigDecimal bd = a instanceof BigDecimal ? (BigDecimal)a : (BigDecimal)b;
                    if (bd.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) > 0 || bd.compareTo(BigDecimal.valueOf(-1.7976931348623157E308)) < 0) {
                        return false;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            double d1 = a.doubleValue();
            double d2 = b.doubleValue();
            return DeepEquals.nearlyEqual(d1, d2, 1.0E-15);
        }
        try {
            BigDecimal x = Converter.convert2BigDecimal(a);
            BigDecimal y = Converter.convert2BigDecimal(b);
            return x.compareTo(y) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean nearlyEqual(double a, double b, double epsilon) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || diff < Double.MIN_NORMAL) {
            return diff < epsilon * Double.MIN_NORMAL;
        }
        return diff / (absA + absB) < epsilon;
    }

    private static boolean compareAtomicBoolean(AtomicBoolean a, AtomicBoolean b) {
        return a.get() == b.get();
    }

    public static boolean hasCustomEquals(Class<?> c) {
        Method equals = ReflectionUtils.getMethod(c, "equals", Object.class);
        return equals.getDeclaringClass() != Object.class;
    }

    public static boolean hasCustomHashCode(Class<?> c) {
        Method hashCode = ReflectionUtils.getMethod(c, "hashCode", new Class[0]);
        return hashCode.getDeclaringClass() != Object.class;
    }

    public static int deepHashCode(Object obj) {
        Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        return DeepEquals.deepHashCode(obj, visited);
    }

    private static int deepHashCode(Object obj, Set<Object> visited) {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                long result = 1L;
                for (int i = 0; i < len; ++i) {
                    Object element = Array.get(obj, i);
                    result = 31L * result + (long)DeepEquals.hashElement(visited, element);
                }
                hash += (int)result;
                continue;
            }
            if (obj instanceof List) {
                List col = (List)obj;
                long result = 1L;
                for (Object element : col) {
                    result = 31L * result + (long)DeepEquals.hashElement(visited, element);
                }
                hash += (int)result;
                continue;
            }
            if (obj instanceof Collection) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (obj instanceof Float) {
                hash += DeepEquals.hashFloat(((Float)obj).floatValue());
                continue;
            }
            if (obj instanceof Double) {
                hash += DeepEquals.hashDouble((Double)obj);
                continue;
            }
            if (DeepEquals.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            List<Field> fields = ReflectionUtils.getAllDeclaredFields(obj.getClass());
            for (Field field : fields) {
                try {
                    if (field.isSynthetic()) continue;
                    stack.addFirst(field.get(obj));
                }
                catch (Exception exception) {}
            }
        }
        return hash;
    }

    private static int hashElement(Set<Object> visited, Object element) {
        if (element == null) {
            return 0;
        }
        if (element instanceof Double) {
            return DeepEquals.hashDouble((Double)element);
        }
        if (element instanceof Float) {
            return DeepEquals.hashFloat(((Float)element).floatValue());
        }
        if (Converter.isSimpleTypeConversionSupported(element.getClass(), element.getClass())) {
            return element.hashCode();
        }
        return DeepEquals.deepHashCode(element, visited);
    }

    private static int hashDouble(double value) {
        double normalizedValue = (double)Math.round(value * SCALE_DOUBLE) / SCALE_DOUBLE;
        long bits = Double.doubleToLongBits(normalizedValue);
        return (int)(bits ^ bits >>> 32);
    }

    private static int hashFloat(float value) {
        float normalizedValue = (float)Math.round(value * SCALE_FLOAT) / SCALE_FLOAT;
        return Float.floatToIntBits(normalizedValue);
    }

    private static String generateBreadcrumb(Deque<ItemsToCompare> stack) {
        ItemsToCompare diffItem = stack.peek();
        StringBuilder result = new StringBuilder();
        PathResult pr = DeepEquals.buildPathContextAndPhrase(diffItem);
        String pathStr = pr.path;
        result.append("[");
        result.append(pr.mismatchPhrase);
        result.append("] ");
        result.append(TRIANGLE_ARROW);
        result.append(" ");
        result.append(pathStr);
        result.append("\n");
        DeepEquals.formatDifference(result, diffItem);
        return result.toString();
    }

    private static PathResult buildPathContextAndPhrase(ItemsToCompare diffItem) {
        List<ItemsToCompare> path = DeepEquals.getPath(diffItem);
        StringBuilder sb = new StringBuilder();
        ItemsToCompare rootItem = path.get(0);
        sb.append(DeepEquals.formatRootObject(rootItem._key1));
        StringBuilder sb2 = new StringBuilder();
        for (int i = 1; i < path.size(); ++i) {
            ItemsToCompare cur = path.get(i);
            if (cur.mapKey != null) {
                DeepEquals.appendSpaceIfNeeded(sb2);
                sb2.append(ANGLE_LEFT).append(DeepEquals.formatMapKey(cur.mapKey)).append(" ").append(ARROW).append(" ").append(DeepEquals.formatValueConcise(cur._key1)).append(ANGLE_RIGHT);
                continue;
            }
            if (cur.fieldName != null) {
                sb2.append(".").append(cur.fieldName);
                continue;
            }
            if (cur.arrayIndices == null) continue;
            for (int idx : cur.arrayIndices) {
                boolean isArray = cur.difference.name().contains("ARRAY");
                sb2.append(isArray ? "[" : "(");
                sb2.append(idx);
                sb2.append(isArray ? "]" : ")");
            }
        }
        if (sb2.length() > 0) {
            sb.append(" ");
            sb.append(TRIANGLE_ARROW);
            sb.append(" ");
            sb.append((CharSequence)sb2);
        }
        String mismatchPhrase = DeepEquals.getContainingDescription(path);
        return new PathResult(sb.toString(), mismatchPhrase);
    }

    private static String getContainingDescription(List<ItemsToCompare> path) {
        String b;
        Difference diff;
        ListIterator<ItemsToCompare> it = path.listIterator(path.size());
        String a = it.previous().difference.getDescription();
        if (it.hasPrevious() && (diff = it.previous().difference) != null && (b = diff.getDescription()) != null) {
            return b;
        }
        return a;
    }

    private static void appendSpaceIfNeeded(StringBuilder sb) {
        char last;
        if (sb.length() > 0 && (last = sb.charAt(sb.length() - 1)) != ' ' && last != '.' && last != '[') {
            sb.append(' ');
        }
    }

    private static Class<?> getCollectionElementType(Collection<?> col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        for (Object item : col) {
            if (item == null) continue;
            return item.getClass();
        }
        return null;
    }

    private static List<ItemsToCompare> getPath(ItemsToCompare diffItem) {
        ArrayList<ItemsToCompare> path = new ArrayList<ItemsToCompare>();
        ItemsToCompare current = diffItem;
        while (current != null) {
            path.add(0, current);
            current = current.parent;
        }
        return path;
    }

    private static void formatDifference(StringBuilder result, ItemsToCompare item) {
        if (item.difference == null) {
            return;
        }
        DiffCategory category = item.difference.getCategory();
        if (item.parent.difference != null) {
            category = item.parent.difference.category;
        }
        switch (category.ordinal()) {
            case 2: {
                result.append(String.format("  Expected size: %d%n  Found size: %d", DeepEquals.getContainerSize(item._key1), DeepEquals.getContainerSize(item._key2)));
                break;
            }
            case 1: {
                result.append(String.format("  Expected type: %s%n  Found type: %s", DeepEquals.getTypeDescription(item._key1 != null ? item._key1.getClass() : null), DeepEquals.getTypeDescription(item._key2 != null ? item._key2.getClass() : null)));
                break;
            }
            case 3: {
                result.append(String.format("  Expected length: %d%n  Found length: %d", Array.getLength(item._key1), Array.getLength(item._key2)));
                break;
            }
            case 4: {
                result.append(String.format("  Expected dimensions: %d%n  Found dimensions: %d", DeepEquals.getDimensions(item._key1), DeepEquals.getDimensions(item._key2)));
                break;
            }
            default: {
                result.append(String.format("  Expected: %s%n  Found: %s", DeepEquals.formatDifferenceValue(item._key1), DeepEquals.formatDifferenceValue(item._key2)));
            }
        }
    }

    private static String formatDifferenceValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (Converter.isSimpleTypeConversionSupported(value.getClass(), value.getClass())) {
            return DeepEquals.formatSimpleValue(value);
        }
        return DeepEquals.formatValueConcise(value);
    }

    private static int getDimensions(Object array) {
        if (array == null) {
            return 0;
        }
        int dimensions = 0;
        Class<?> type = array.getClass();
        while (type.isArray()) {
            ++dimensions;
            type = type.getComponentType();
        }
        return dimensions;
    }

    private static String formatValueConcise(Object value) {
        if (value == null) {
            return "null";
        }
        try {
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                String typeName = value.getClass().getSimpleName();
                return String.format("%s(%s)", typeName, col.isEmpty() ? EMPTY : "0.." + (col.size() - 1));
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                String typeName = value.getClass().getSimpleName();
                return String.format("%s(%s)", typeName, map.isEmpty() ? EMPTY : "0.." + (map.size() - 1));
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                String typeName = DeepEquals.getTypeDescription(value.getClass().getComponentType());
                return String.format("%s[%s]", typeName, length == 0 ? EMPTY : "0.." + (length - 1));
            }
            if (Converter.isSimpleTypeConversionSupported(value.getClass(), value.getClass())) {
                return DeepEquals.formatSimpleValue(value);
            }
            List<Field> fields = ReflectionUtils.getAllDeclaredFields(value.getClass());
            StringBuilder sb = new StringBuilder(value.getClass().getSimpleName());
            sb.append(" {");
            boolean first = true;
            for (Field field : fields) {
                if (field.isSynthetic()) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                Object fieldValue = field.get(value);
                sb.append(field.getName()).append(": ");
                if (fieldValue == null) {
                    sb.append("null");
                    continue;
                }
                Class<?> fieldType = field.getType();
                if (Converter.isSimpleTypeConversionSupported(fieldType, fieldType)) {
                    sb.append(DeepEquals.formatSimpleValue(fieldValue));
                    continue;
                }
                if (fieldType.isArray()) {
                    int length = Array.getLength(fieldValue);
                    String typeName = DeepEquals.getTypeDescription(fieldType.getComponentType());
                    sb.append(String.format("%s[%s]", typeName, length == 0 ? EMPTY : "0.." + (length - 1)));
                    continue;
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    Collection col = (Collection)fieldValue;
                    sb.append(String.format("%s(%s)", fieldType.getSimpleName(), col.isEmpty() ? EMPTY : "0.." + (col.size() - 1)));
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    Map map = (Map)fieldValue;
                    sb.append(String.format("%s(%s)", fieldType.getSimpleName(), map.isEmpty() ? EMPTY : "0.." + (map.size() - 1)));
                    continue;
                }
                sb.append("{..}");
            }
            sb.append("}");
            return sb.toString();
        }
        catch (Exception e) {
            return value.getClass().getSimpleName();
        }
    }

    private static String formatSimpleValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof AtomicBoolean) {
            return String.valueOf(((AtomicBoolean)value).get());
        }
        if (value instanceof AtomicInteger) {
            return String.valueOf(((AtomicInteger)value).get());
        }
        if (value instanceof AtomicLong) {
            return String.valueOf(((AtomicLong)value).get());
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Character) {
            return "'" + value + "'";
        }
        if (value instanceof Number) {
            return DeepEquals.formatNumber((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)value);
        }
        if (value instanceof TimeZone) {
            TimeZone timeZone = (TimeZone)value;
            return "TimeZone: " + timeZone.getID();
        }
        if (value instanceof URI) {
            return value.toString();
        }
        if (value instanceof URL) {
            return value.toString();
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        return value.getClass().getSimpleName() + ":" + value;
    }

    private static String formatValue(Object value) {
        if (value == null) {
            return "null";
        }
        Set<Object> stack = formattingStack.get();
        if (!stack.add(value)) {
            return "<circular " + value.getClass().getSimpleName() + ">";
        }
        try {
            if (value instanceof Number) {
                String string = DeepEquals.formatNumber((Number)value);
                return string;
            }
            if (value instanceof String) {
                String string = "\"" + value + "\"";
                return string;
            }
            if (value instanceof Character) {
                String string = "'" + value + "'";
                return string;
            }
            if (value instanceof Date) {
                String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)value);
                return string;
            }
            if (Converter.isSimpleTypeConversionSupported(value.getClass(), value.getClass())) {
                String string = String.valueOf(value);
                return string;
            }
            if (value instanceof Collection) {
                String string = DeepEquals.formatCollectionContents((Collection)value);
                return string;
            }
            if (value instanceof Map) {
                String string = DeepEquals.formatMapContents((Map)value);
                return string;
            }
            if (value.getClass().isArray()) {
                String string = DeepEquals.formatArrayContents(value);
                return string;
            }
            String string = DeepEquals.formatComplexObject(value);
            return string;
        }
        finally {
            stack.remove(value);
        }
    }

    private static String formatArrayContents(Object array) {
        Class<?> type;
        int limit = 3;
        Class<?> componentType = type = array.getClass();
        while (componentType.getComponentType() != null) {
            componentType = componentType.getComponentType();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(componentType.getSimpleName());
        int outerLength = Array.getLength(array);
        sb.append("[").append(outerLength).append("]");
        for (Class<?> current = type.getComponentType(); current != null && current.isArray(); current = current.getComponentType()) {
            sb.append("[]");
        }
        sb.append("{");
        int length = Array.getLength(array);
        if (length > 0) {
            int showItems = Math.min(length, 3);
            for (int i = 0; i < showItems; ++i) {
                Object item;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((item = Array.get(array, i)) == null) {
                    sb.append("null");
                    continue;
                }
                if (item.getClass().isArray()) {
                    int subLength = Array.getLength(item);
                    sb.append('[');
                    for (int j = 0; j < Math.min(subLength, 3); ++j) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        sb.append(DeepEquals.formatValue(Array.get(item, j)));
                    }
                    if (subLength > 3) {
                        sb.append(", ...");
                    }
                    sb.append(']');
                    continue;
                }
                sb.append(DeepEquals.formatValue(item));
            }
            if (length > 3) {
                sb.append(", ...");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static String formatCollectionContents(Collection<?> collection) {
        int limit = 3;
        StringBuilder sb = new StringBuilder();
        Class<?> type = collection.getClass();
        Class<?> elementType = DeepEquals.getCollectionElementType(collection);
        sb.append(type.getSimpleName());
        if (elementType != null) {
            sb.append("<").append(DeepEquals.getTypeSimpleName(elementType)).append(">");
        }
        sb.append("(").append(collection.size()).append(")");
        sb.append("{");
        if (!collection.isEmpty()) {
            Iterator<?> it = collection.iterator();
            for (int count = 0; count < 3 && it.hasNext(); ++count) {
                Object item;
                if (count > 0) {
                    sb.append(", ");
                }
                if ((item = it.next()) == null) {
                    sb.append("null");
                    continue;
                }
                if (item instanceof Collection) {
                    Collection subCollection = (Collection)item;
                    sb.append("(");
                    Iterator subIt = subCollection.iterator();
                    for (int j = 0; j < Math.min(subCollection.size(), 3); ++j) {
                        if (j > 0) {
                            sb.append(", ");
                        }
                        sb.append(DeepEquals.formatValue(subIt.next()));
                    }
                    if (subCollection.size() > 3) {
                        sb.append(", ...");
                    }
                    sb.append(")");
                    continue;
                }
                sb.append(DeepEquals.formatValue(item));
            }
            if (collection.size() > 3) {
                sb.append(", ...");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static String formatMapContents(Map<?, ?> map) {
        int limit = 3;
        StringBuilder sb = new StringBuilder();
        Class<?> type = map.getClass();
        Type[] typeArgs = DeepEquals.getMapTypes(map);
        sb.append(type.getSimpleName());
        if (typeArgs != null && typeArgs.length == 2) {
            sb.append("<").append(DeepEquals.getTypeSimpleName(typeArgs[0])).append(", ").append(DeepEquals.getTypeSimpleName(typeArgs[1])).append(">");
        }
        sb.append("(").append(map.size()).append(")");
        if (!map.isEmpty()) {
            Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
            for (int count = 0; count < 3 && it.hasNext(); ++count) {
                if (count > 0) {
                    sb.append(", ");
                }
                Map.Entry<?, ?> entry = it.next();
                sb.append(ANGLE_LEFT).append(DeepEquals.formatValue(entry.getKey())).append(" ").append(ARROW).append(" ").append(DeepEquals.formatValue(entry.getValue())).append(ANGLE_RIGHT);
            }
            if (map.size() > 3) {
                sb.append(", ...");
            }
        }
        return sb.toString();
    }

    private static String getTypeSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.getTypeName();
    }

    private static String formatComplexObject(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getSimpleName());
        sb.append(" {");
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(obj.getClass());
        boolean first = true;
        for (Field field : fields) {
            try {
                if (field.isSynthetic()) continue;
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(field.getName()).append(": ");
                Object value = field.get(obj);
                if (value == obj) {
                    sb.append("(this ").append(obj.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(DeepEquals.formatValue(value));
            }
            catch (Exception exception) {}
        }
        sb.append("}");
        return sb.toString();
    }

    private static String formatArrayNotation(Object array) {
        if (array == null) {
            return "null";
        }
        int length = Array.getLength(array);
        String typeName = DeepEquals.getTypeDescription(array.getClass().getComponentType());
        return String.format("%s[%s]", typeName, length == 0 ? EMPTY : "0.." + (length - 1));
    }

    private static String formatCollectionNotation(Collection<?> col) {
        StringBuilder sb = new StringBuilder();
        sb.append(col.getClass().getSimpleName());
        Class<?> elementType = DeepEquals.getCollectionElementType(col);
        if (elementType != null && elementType != Object.class) {
            sb.append("<").append(DeepEquals.getTypeDescription(elementType)).append(">");
        }
        sb.append("(");
        if (col.isEmpty()) {
            sb.append(EMPTY);
        } else {
            sb.append("0..").append(col.size() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    private static String formatMapNotation(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(map.getClass().getSimpleName());
        sb.append("(");
        if (map.isEmpty()) {
            sb.append(EMPTY);
        } else {
            sb.append("0..").append(map.size() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    private static String formatMapKey(Object key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof String) {
            return "\"" + key + "\"";
        }
        String text = DeepEquals.formatValue(key);
        return StringUtilities.removeLeadingAndTrailingQuotes(text);
    }

    private static String formatNumber(Number value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            double doubleValue = bd.doubleValue();
            if (Math.abs(doubleValue) >= 1.0E16 || Math.abs(doubleValue) < 1.0E-6 && doubleValue != 0.0) {
                return String.format("%.6e", doubleValue);
            }
            if (Math.abs(doubleValue) <= 1.0) {
                return bd.stripTrailingZeros().toPlainString();
            }
            return bd.stripTrailingZeros().toPlainString();
        }
        if (value instanceof Double || value instanceof Float) {
            double d = value.doubleValue();
            if (Math.abs(d) >= 1.0E16 || Math.abs(d) < 1.0E-6 && d != 0.0) {
                return String.format("%.6e", d);
            }
            if (value instanceof Double) {
                return String.format("%.15g", d).replaceAll("\\.?0+$", "");
            }
            return String.format("%.7g", d).replaceAll("\\.?0+$", "");
        }
        return value.toString();
    }

    private static String formatRootObject(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Collection) {
            return DeepEquals.formatCollectionNotation((Collection)obj);
        }
        if (obj instanceof Map) {
            return DeepEquals.formatMapNotation((Map)obj);
        }
        if (obj.getClass().isArray()) {
            return DeepEquals.formatArrayNotation(obj);
        }
        if (Converter.isSimpleTypeConversionSupported(obj.getClass(), obj.getClass())) {
            return String.format("%s: %s", DeepEquals.getTypeDescription(obj.getClass()), DeepEquals.formatSimpleValue(obj));
        }
        return DeepEquals.formatValueConcise(obj);
    }

    private static String getTypeDescription(Class<?> type) {
        if (type == null) {
            return "Object";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return DeepEquals.getTypeDescription(componentType) + "[]";
        }
        return type.getSimpleName();
    }

    private static Type[] getMapTypes(Map<?, ?> map) {
        Type type = map.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return null;
    }

    private static int getContainerSize(Object container) {
        if (container == null) {
            return 0;
        }
        if (container instanceof Collection) {
            return ((Collection)container).size();
        }
        if (container instanceof Map) {
            return ((Map)container).size();
        }
        if (container.getClass().isArray()) {
            return Array.getLength(container);
        }
        return 0;
    }

    private static final class ItemsToCompare {
        private final Object _key1;
        private final Object _key2;
        private final ItemsToCompare parent;
        private final String fieldName;
        private final int[] arrayIndices;
        private final Object mapKey;
        private final Difference difference;

        private ItemsToCompare(Object k1, Object k2) {
            this(k1, k2, null, null, null, null, null);
        }

        private ItemsToCompare(Object k1, Object k2, ItemsToCompare parent, Difference difference) {
            this(k1, k2, parent, null, null, null, difference);
        }

        private ItemsToCompare(Object k1, Object k2, String fieldName, ItemsToCompare parent, Difference difference) {
            this(k1, k2, parent, fieldName, null, null, difference);
        }

        private ItemsToCompare(Object k1, Object k2, int[] indices, ItemsToCompare parent, Difference difference) {
            this(k1, k2, parent, null, indices, null, difference);
        }

        private ItemsToCompare(Object k1, Object k2, Object mapKey, ItemsToCompare parent, boolean isMapKey, Difference difference) {
            this(k1, k2, parent, null, null, mapKey, difference);
        }

        private ItemsToCompare(Object k1, Object k2, ItemsToCompare parent, String fieldName, int[] arrayIndices, Object mapKey, Difference difference) {
            this._key1 = k1;
            this._key2 = k2;
            this.parent = parent;
            this.fieldName = fieldName;
            this.arrayIndices = arrayIndices;
            this.mapKey = mapKey;
            this.difference = difference;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ItemsToCompare)) {
                return false;
            }
            ItemsToCompare that = (ItemsToCompare)other;
            return this._key1 == that._key1 && this._key2 == that._key2;
        }

        public int hashCode() {
            return System.identityHashCode(this._key1) * 31 + System.identityHashCode(this._key2);
        }
    }

    private static enum Difference {
        VALUE_MISMATCH("value mismatch", DiffCategory.VALUE),
        FIELD_VALUE_MISMATCH("field value mismatch", DiffCategory.VALUE),
        COLLECTION_SIZE_MISMATCH("collection size mismatch", DiffCategory.SIZE),
        COLLECTION_MISSING_ELEMENT("missing collection element", DiffCategory.VALUE),
        COLLECTION_TYPE_MISMATCH("collection type mismatch", DiffCategory.TYPE),
        COLLECTION_ELEMENT_MISMATCH("collection element mismatch", DiffCategory.VALUE),
        MAP_SIZE_MISMATCH("map size mismatch", DiffCategory.SIZE),
        MAP_MISSING_KEY("missing map key", DiffCategory.VALUE),
        MAP_VALUE_MISMATCH("map value mismatch", DiffCategory.VALUE),
        ARRAY_DIMENSION_MISMATCH("array dimensionality mismatch", DiffCategory.DIMENSION),
        ARRAY_COMPONENT_TYPE_MISMATCH("array component type mismatch", DiffCategory.TYPE),
        ARRAY_LENGTH_MISMATCH("array length mismatch", DiffCategory.LENGTH),
        ARRAY_ELEMENT_MISMATCH("array element mismatch", DiffCategory.VALUE),
        TYPE_MISMATCH("type mismatch", DiffCategory.TYPE);

        private final String description;
        private final DiffCategory category;

        private Difference(String description, DiffCategory category) {
            this.description = description;
            this.category = category;
        }

        String getDescription() {
            return this.description;
        }

        DiffCategory getCategory() {
            return this.category;
        }
    }

    private static class PathResult {
        final String path;
        final String mismatchPhrase;

        PathResult(String path, String mismatchPhrase) {
            this.path = path;
            this.mismatchPhrase = mismatchPhrase;
        }
    }

    private static enum DiffCategory {
        VALUE,
        TYPE,
        SIZE,
        LENGTH,
        DIMENSION;

    }
}

