/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.CalendarConversions;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;

final class InstantConversions {
    private InstantConversions() {
    }

    static Map toMap(Object from, Converter converter) {
        long sec = ((Instant)from).getEpochSecond();
        int nanos = ((Instant)from).getNano();
        CompactMap<String, Number> target = CompactMap.builder().insertionOrder().build();
        target.put("seconds", sec);
        target.put("nanos", nanos);
        return target;
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return ((Instant)from).atZone(converter.getOptions().getZoneId());
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        Instant instant = (Instant)from;
        TimeZone timeZone = converter.getOptions().getTimeZone();
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timeZone.getOffset(System.currentTimeMillis()) / 1000);
        return instant.atOffset(zoneOffset);
    }

    static long toLong(Object from, Converter converter) {
        return ((Instant)from).toEpochMilli();
    }

    static double toDouble(Object from, Converter converter) {
        Instant instant = (Instant)from;
        return BigDecimalConversions.secondsAndNanosToDouble(instant.getEpochSecond(), instant.getNano()).doubleValue();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(InstantConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return Timestamp.from((Instant)from);
    }

    static Date toSqlDate(Object from, Converter converter) {
        return new Date(InstantConversions.toLong(from, converter));
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return new java.util.Date(InstantConversions.toLong(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        return CalendarConversions.create(InstantConversions.toLong(from, converter), converter);
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = (Instant)from;
        long seconds = instant.getEpochSecond();
        int nanoseconds = instant.getNano();
        return BigInteger.valueOf(seconds).multiply(BigIntegerConversions.BILLION).add(BigInteger.valueOf(nanoseconds));
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Instant instant = (Instant)from;
        return BigDecimalConversions.secondsAndNanosToDouble(instant.getEpochSecond(), instant.getNano());
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return InstantConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return InstantConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return InstantConversions.toZonedDateTime(from, converter).toLocalTime();
    }
}

