/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.sender;

import com.cloudbees.syslog.SyslogMessage;
import com.cloudbees.syslog.sender.AbstractSyslogMessageSender;
import com.cloudbees.syslog.util.CachingReference;
import com.cloudbees.syslog.util.IoUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TcpSyslogMessageSender
extends AbstractSyslogMessageSender {
    public static final int SETTING_SOCKET_CONNECT_TIMEOUT_IN_MILLIS_DEFAULT_VALUE = 500;
    protected CachingReference<InetAddress> syslogServerHostnameReference;
    protected int syslogServerPort = 514;
    private Socket socket;
    private Writer writer;
    private int socketConnectTimeoutInMillis = 500;
    private boolean ssl;

    @Override
    public synchronized void sendMessage(@Nonnull SyslogMessage message) throws IOException {
        this.ensureSyslogServerConnection();
        this.sendCounter.incrementAndGet();
        long nanosBefore = System.nanoTime();
        try {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Send syslog message " + message.toSyslogMessage(this.messageFormat));
            }
            message.toSyslogMessage(this.messageFormat, this.writer);
            this.writer.write("\r\n");
            this.writer.flush();
        }
        catch (IOException e) {
            this.sendErrorCounter.incrementAndGet();
            throw e;
        }
        catch (RuntimeException e) {
            this.sendErrorCounter.incrementAndGet();
            throw e;
        }
        finally {
            this.sendDurationInNanosCounter.addAndGet(System.nanoTime() - nanosBefore);
        }
    }

    private synchronized void ensureSyslogServerConnection() throws IOException {
        boolean socketIsValid;
        InetAddress inetAddress = this.syslogServerHostnameReference.get();
        if (this.socket != null && !this.socket.getInetAddress().equals(inetAddress)) {
            this.logger.info("InetAddress of the Syslog Server have changed, create a new connection. Before=" + this.socket.getInetAddress() + ", new=" + inetAddress);
            IoUtils.closeQuietly(this.socket, this.writer);
            this.writer = null;
            this.socket = null;
        }
        try {
            socketIsValid = this.socket != null && this.socket.isConnected() && this.socket.isBound() && !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
        }
        catch (Exception e) {
            socketIsValid = false;
        }
        if (!socketIsValid) {
            this.writer = null;
            try {
                this.socket = this.ssl ? SSLSocketFactory.getDefault().createSocket() : SocketFactory.getDefault().createSocket();
                this.socket.setKeepAlive(true);
                this.socket.connect(new InetSocketAddress(inetAddress, this.syslogServerPort), this.socketConnectTimeoutInMillis);
                if (this.socket instanceof SSLSocket && this.logger.isLoggable(Level.FINER)) {
                    try {
                        SSLSocket sslSocket = (SSLSocket)this.socket;
                        SSLSession session = sslSocket.getSession();
                        this.logger.finer("The Certificates used by peer");
                        for (Certificate certificate : session.getPeerCertificates()) {
                            if (certificate instanceof X509Certificate) {
                                X509Certificate x509Certificate = (X509Certificate)certificate;
                                this.logger.finer("" + x509Certificate.getSubjectDN());
                                continue;
                            }
                            this.logger.finer("" + certificate);
                        }
                        this.logger.finer("Peer host is " + session.getPeerHost());
                        this.logger.finer("Cipher is " + session.getCipherSuite());
                        this.logger.finer("Protocol is " + session.getProtocol());
                        this.logger.finer("ID is " + new BigInteger(session.getId()));
                        this.logger.finer("Session created in " + session.getCreationTime());
                        this.logger.finer("Session accessed in " + session.getLastAccessedTime());
                    }
                    catch (Exception e) {
                        this.logger.warn("Exception dumping debug info for " + this.socket, e);
                    }
                }
            }
            catch (IOException e) {
                ConnectException ce = new ConnectException("Exception connecting to " + inetAddress + ":" + this.syslogServerPort);
                ce.initCause(e);
                throw ce;
            }
        }
        if (this.writer == null) {
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), UTF_8));
        }
    }

    public void setSyslogServerHostname(final String syslogServerHostname) {
        this.syslogServerHostnameReference = new CachingReference<InetAddress>(DEFAULT_INET_ADDRESS_TTL_IN_NANOS){

            @Override
            @Nullable
            protected InetAddress newObject() {
                try {
                    return InetAddress.getByName(syslogServerHostname);
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    public void setSyslogServerPort(int syslogServerPort) {
        this.syslogServerPort = syslogServerPort;
    }

    public String getSyslogServerHostname() {
        return this.syslogServerHostnameReference.get().getHostName();
    }

    public int getSyslogServerPort() {
        return this.syslogServerPort;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }
}

