/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog.util;

import com.cloudbees.syslog.integration.jul.util.LevelHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InternalLogger {
    private static Level level;
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private final String name;
    private final Logger julLogger;

    public static InternalLogger getLogger(@Nonnull String name) {
        return new InternalLogger(name);
    }

    public static InternalLogger getLogger(@Nonnull Class clazz) {
        return InternalLogger.getLogger(clazz.getName());
    }

    public static Level getLevel() {
        return level;
    }

    public static void setLevel(Level level) {
        InternalLogger.level = level;
    }

    public InternalLogger(String name) {
        this.name = name;
        this.julLogger = Logger.getLogger(name);
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            return false;
        }
        if (InternalLogger.level == null) {
            return this.julLogger.isLoggable(level);
        }
        return level.intValue() >= InternalLogger.level.intValue();
    }

    public void finest(@Nullable String msg) {
        this.log(Level.FINEST, msg);
    }

    public void fine(@Nullable String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(@Nullable String msg) {
        this.log(Level.FINER, msg);
    }

    public void info(@Nullable String msg) {
        this.log(Level.INFO, msg);
    }

    public void log(@Nullable Level level, @Nullable String msg) {
        this.log(level, msg, null);
    }

    public void warn(@Nullable String msg) {
        this.log(Level.WARNING, msg);
    }

    public void warn(@Nullable String msg, @Nullable Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    public synchronized void log(@Nullable Level level, @Nullable String msg, @Nullable Throwable t) {
        if (!this.isLoggable(level)) {
            return;
        }
        System.err.println(this.df.format(new Date()) + " [" + Thread.currentThread().getName() + "] " + this.name + " - " + level.getName() + ": " + msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    static {
        try {
            level = LevelHelper.findLevel(System.getProperty("com.cloudbees.syslog.debugLevel"));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

