/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.processor.response.successful;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.dto.result.Status;
import com.cloudconvert.processor.content.ContentPreProcessor;
import com.cloudconvert.processor.content.DataExtractingContentPreProcessor;
import com.cloudconvert.processor.content.DefaultContentPreProcessor;
import com.cloudconvert.processor.response.ResponseProcessor;
import com.cloudconvert.resource.AbstractResource;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ContentResponseProcessor
implements ResponseProcessor {
    private final ObjectMapperProvider objectMapperProvider;
    private final ContentPreProcessor defaultContentPreProcessor;
    private final Map<TypeReference<?>, ContentPreProcessor> contentPreProcessors;

    public ContentResponseProcessor(ObjectMapperProvider objectMapperProvider) {
        this.objectMapperProvider = objectMapperProvider;
        DataExtractingContentPreProcessor dataExtractionContentPreProcessor = new DataExtractingContentPreProcessor();
        this.defaultContentPreProcessor = new DefaultContentPreProcessor();
        this.contentPreProcessors = ImmutableMap.builder().put(AbstractResource.TASK_RESPONSE_TYPE_REFERENCE, (Object)dataExtractionContentPreProcessor).put(AbstractResource.JOB_RESPONSE_TYPE_REFERENCE, (Object)dataExtractionContentPreProcessor).put(AbstractResource.USER_RESPONSE_TYPE_REFERENCE, (Object)dataExtractionContentPreProcessor).put(AbstractResource.WEBHOOKS_RESPONSE_TYPE_REFERENCE, (Object)dataExtractionContentPreProcessor).build();
    }

    @Override
    public <T> Result<T> process(Status status, Map<String, String> headers, InputStream inputStream, TypeReference<T> typeReference) throws IOException {
        String string = this.contentPreProcessors.getOrDefault(typeReference, this.defaultContentPreProcessor).preProcess(inputStream);
        return Result.builder().status(status).headers(headers).body(this.objectMapperProvider.provide().readValue(string, typeReference)).build();
    }
}

