/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Map;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public class JSON {
    private Gson gson;
    private boolean isLenientOnJson = false;
    private DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();

    public static GsonBuilder createGson() {
        GsonFireBuilder gsonFireBuilder = new GsonFireBuilder();
        return gsonFireBuilder.createGsonBuilder();
    }

    private static String getDiscriminatorValue(JsonElement jsonElement, String string) {
        JsonElement jsonElement2 = jsonElement.getAsJsonObject().get(string);
        if (null == jsonElement2) {
            throw new IllegalArgumentException("missing discriminator field: <" + string + ">");
        }
        return jsonElement2.getAsString();
    }

    private static Class getClassByDiscriminator(Map map, String string) {
        Class clazz = (Class)map.get(string.toUpperCase());
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + string + ">");
        }
        return clazz;
    }

    public JSON() {
        this.gson = JSON.createGson().registerTypeAdapter(java.util.Date.class, (Object)this.dateTypeAdapter).registerTypeAdapter(Date.class, (Object)this.sqlDateTypeAdapter).registerTypeAdapter(OffsetDateTime.class, (Object)this.offsetDateTimeTypeAdapter).registerTypeAdapter(LocalDate.class, (Object)this.localDateTypeAdapter).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public JSON setGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public JSON setLenientOnJson(boolean bl) {
        this.isLenientOnJson = bl;
        return this;
    }

    public String serialize(Object object) {
        return this.gson.toJson(object);
    }

    public <T> T deserialize(String string, Type type) {
        try {
            if (this.isLenientOnJson) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));
                jsonReader.setLenient(true);
                return (T)this.gson.fromJson(jsonReader, type);
            }
            return (T)this.gson.fromJson(string, type);
        }
        catch (JsonParseException jsonParseException) {
            if (type.equals(String.class)) {
                return (T)string;
            }
            throw jsonParseException;
        }
    }

    public JSON setOffsetDateTimeFormat(DateTimeFormatter dateTimeFormatter) {
        this.offsetDateTimeTypeAdapter.setFormat(dateTimeFormatter);
        return this;
    }

    public JSON setLocalDateFormat(DateTimeFormatter dateTimeFormatter) {
        this.localDateTypeAdapter.setFormat(dateTimeFormatter);
        return this;
    }

    public JSON setDateFormat(DateFormat dateFormat) {
        this.dateTypeAdapter.setFormat(dateFormat);
        return this;
    }

    public JSON setSqlDateFormat(DateFormat dateFormat) {
        this.sqlDateTypeAdapter.setFormat(dateFormat);
        return this;
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter jsonWriter, java.util.Date date) throws IOException {
            if (date == null) {
                jsonWriter.nullValue();
            } else {
                String string = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format((java.util.Date)date, (boolean)true);
                jsonWriter.value(string);
            }
        }

        public java.util.Date read(JsonReader jsonReader) throws IOException {
            try {
                switch (jsonReader.peek()) {
                    case NULL: {
                        jsonReader.nextNull();
                        return null;
                    }
                }
                String string = jsonReader.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(string);
                    }
                    return ISO8601Utils.parse((String)string, (ParsePosition)new ParsePosition(0));
                }
                catch (ParseException parseException) {
                    throw new JsonParseException((Throwable)parseException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonParseException((Throwable)illegalArgumentException);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter jsonWriter, Date date) throws IOException {
            if (date == null) {
                jsonWriter.nullValue();
            } else {
                String string = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                jsonWriter.value(string);
            }
        }

        public Date read(JsonReader jsonReader) throws IOException {
            switch (jsonReader.peek()) {
                case NULL: {
                    jsonReader.nextNull();
                    return null;
                }
            }
            String string = jsonReader.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(string).getTime());
                }
                return new Date(ISO8601Utils.parse((String)string, (ParsePosition)new ParsePosition(0)).getTime());
            }
            catch (ParseException parseException) {
                throw new JsonParseException((Throwable)parseException);
            }
        }
    }

    public class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter dateTimeFormatter) {
            this.formatter = dateTimeFormatter;
        }

        public void setFormat(DateTimeFormatter dateTimeFormatter) {
            this.formatter = dateTimeFormatter;
        }

        public void write(JsonWriter jsonWriter, LocalDate localDate) throws IOException {
            if (localDate == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(this.formatter.format((TemporalAccessor)localDate));
            }
        }

        public LocalDate read(JsonReader jsonReader) throws IOException {
            switch (jsonReader.peek()) {
                case NULL: {
                    jsonReader.nextNull();
                    return null;
                }
            }
            String string = jsonReader.nextString();
            return LocalDate.parse((CharSequence)string, (DateTimeFormatter)this.formatter);
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter dateTimeFormatter) {
            this.formatter = dateTimeFormatter;
        }

        public void setFormat(DateTimeFormatter dateTimeFormatter) {
            this.formatter = dateTimeFormatter;
        }

        public void write(JsonWriter jsonWriter, OffsetDateTime offsetDateTime) throws IOException {
            if (offsetDateTime == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(this.formatter.format((TemporalAccessor)offsetDateTime));
            }
        }

        public OffsetDateTime read(JsonReader jsonReader) throws IOException {
            switch (jsonReader.peek()) {
                case NULL: {
                    jsonReader.nextNull();
                    return null;
                }
            }
            String string = jsonReader.nextString();
            if (string.endsWith("+0000")) {
                string = string.substring(0, string.length() - 5) + "Z";
            }
            return OffsetDateTime.parse((CharSequence)string, (DateTimeFormatter)this.formatter);
        }
    }
}

