/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;
import com.codedx.client.model.Analysis;
import com.codedx.client.model.AnalysisDetails;
import com.codedx.client.model.AnalysisName;
import com.codedx.client.model.AnalysisPrepResponse;
import com.codedx.client.model.AnalysisQueryResponse;
import com.codedx.client.model.Enabled;
import com.codedx.client.model.FileUploadResponse;
import com.codedx.client.model.InputDisplayInfo;
import com.codedx.client.model.ProjectId;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AnalysisApi {
    private ApiClient apiClient;

    public AnalysisApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AnalysisApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createAnalysisPrepCall(ProjectId projectId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ProjectId projectId2 = projectId;
        String string = "/api/analysis-prep";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, projectId2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createAnalysisPrepValidateBeforeCall(ProjectId projectId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling createAnalysisPrep(Async)");
        }
        Call call = this.createAnalysisPrepCall(projectId, progressListener, progressRequestListener);
        return call;
    }

    public AnalysisPrepResponse createAnalysisPrep(ProjectId projectId) throws ApiException {
        ApiResponse<AnalysisPrepResponse> apiResponse = this.createAnalysisPrepWithHttpInfo(projectId);
        return apiResponse.getData();
    }

    public ApiResponse<AnalysisPrepResponse> createAnalysisPrepWithHttpInfo(ProjectId projectId) throws ApiException {
        Call call = this.createAnalysisPrepValidateBeforeCall(projectId, null, null);
        Type type = new TypeToken<AnalysisPrepResponse>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createAnalysisPrepAsync(ProjectId projectId, final ApiCallback<AnalysisPrepResponse> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createAnalysisPrepValidateBeforeCall(projectId, progressListener, progressRequestListener);
        Type type = new TypeToken<AnalysisPrepResponse>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call deleteInputCall(String string, String string2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string3 = "/api/analysis-prep/{prep-id}/{input-id}".replaceAll("\\{prep-id\\}", this.apiClient.escapeString(string.toString())).replaceAll("\\{input-id\\}", this.apiClient.escapeString(string2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string4 = this.apiClient.selectHeaderAccept(stringArray);
        if (string4 != null) {
            hashMap.put("Accept", string4);
        }
        String[] stringArray2 = new String[]{};
        String string5 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string5);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string3, "DELETE", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteInputValidateBeforeCall(String string, String string2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (string == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling deleteInput(Async)");
        }
        if (string2 == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling deleteInput(Async)");
        }
        Call call = this.deleteInputCall(string, string2, progressListener, progressRequestListener);
        return call;
    }

    public void deleteInput(String string, String string2) throws ApiException {
        this.deleteInputWithHttpInfo(string, string2);
    }

    public ApiResponse<Void> deleteInputWithHttpInfo(String string, String string2) throws ApiException {
        Call call = this.deleteInputValidateBeforeCall(string, string2, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteInputAsync(String string, String string2, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteInputValidateBeforeCall(string, string2, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call deletePendingInputCall(String string, String string2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string3 = "/api/analysis-prep/{prep-id}/pending".replaceAll("\\{prep-id\\}", this.apiClient.escapeString(string.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 != null) {
            hashMap.put("X-Client-Request-Id", this.apiClient.parameterToString(string2));
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string4 = this.apiClient.selectHeaderAccept(stringArray);
        if (string4 != null) {
            hashMap.put("Accept", string4);
        }
        String[] stringArray2 = new String[]{};
        String string5 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string5);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string3, "DELETE", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deletePendingInputValidateBeforeCall(String string, String string2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (string == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling deletePendingInput(Async)");
        }
        if (string2 == null) {
            throw new ApiException("Missing the required parameter 'xClientRequestId' when calling deletePendingInput(Async)");
        }
        Call call = this.deletePendingInputCall(string, string2, progressListener, progressRequestListener);
        return call;
    }

    public void deletePendingInput(String string, String string2) throws ApiException {
        this.deletePendingInputWithHttpInfo(string, string2);
    }

    public ApiResponse<Void> deletePendingInputWithHttpInfo(String string, String string2) throws ApiException {
        Call call = this.deletePendingInputValidateBeforeCall(string, string2, null, null);
        return this.apiClient.execute(call);
    }

    public Call deletePendingInputAsync(String string, String string2, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deletePendingInputValidateBeforeCall(string, string2, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call getAllAnalysisDetailsCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/projects/{project-id}/analyses".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getAllAnalysisDetailsValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getAllAnalysisDetails(Async)");
        }
        Call call = this.getAllAnalysisDetailsCall(n, progressListener, progressRequestListener);
        return call;
    }

    public List<AnalysisDetails> getAllAnalysisDetails(Integer n) throws ApiException {
        ApiResponse<List<AnalysisDetails>> apiResponse = this.getAllAnalysisDetailsWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<List<AnalysisDetails>> getAllAnalysisDetailsWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getAllAnalysisDetailsValidateBeforeCall(n, null, null);
        Type type = new TypeToken<List<AnalysisDetails>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getAllAnalysisDetailsAsync(Integer n, final ApiCallback<List<AnalysisDetails>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getAllAnalysisDetailsValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<List<AnalysisDetails>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getAnalysisDetailsCall(Integer n, Integer n2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string = "/api/projects/{project-id}/analyses/{analysis-id}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{analysis-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getAnalysisDetailsValidateBeforeCall(Integer n, Integer n2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getAnalysisDetails(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'analysisId' when calling getAnalysisDetails(Async)");
        }
        Call call = this.getAnalysisDetailsCall(n, n2, progressListener, progressRequestListener);
        return call;
    }

    public AnalysisDetails getAnalysisDetails(Integer n, Integer n2) throws ApiException {
        ApiResponse<AnalysisDetails> apiResponse = this.getAnalysisDetailsWithHttpInfo(n, n2);
        return apiResponse.getData();
    }

    public ApiResponse<AnalysisDetails> getAnalysisDetailsWithHttpInfo(Integer n, Integer n2) throws ApiException {
        Call call = this.getAnalysisDetailsValidateBeforeCall(n, n2, null, null);
        Type type = new TypeToken<AnalysisDetails>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getAnalysisDetailsAsync(Integer n, Integer n2, final ApiCallback<AnalysisDetails> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getAnalysisDetailsValidateBeforeCall(n, n2, progressListener, progressRequestListener);
        Type type = new TypeToken<AnalysisDetails>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getInputMetadataCall(String string, String string2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var5_5 = null;
        String string3 = "/api/analysis-prep/{prep-id}/{input-id}".replaceAll("\\{prep-id\\}", this.apiClient.escapeString(string.toString())).replaceAll("\\{input-id\\}", this.apiClient.escapeString(string2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string4 = this.apiClient.selectHeaderAccept(stringArray);
        if (string4 != null) {
            hashMap.put("Accept", string4);
        }
        String[] stringArray2 = new String[]{};
        String string5 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string5);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string3, "GET", arrayList, arrayList2, var5_5, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getInputMetadataValidateBeforeCall(String string, String string2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (string == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling getInputMetadata(Async)");
        }
        if (string2 == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling getInputMetadata(Async)");
        }
        Call call = this.getInputMetadataCall(string, string2, progressListener, progressRequestListener);
        return call;
    }

    public InputDisplayInfo getInputMetadata(String string, String string2) throws ApiException {
        ApiResponse<InputDisplayInfo> apiResponse = this.getInputMetadataWithHttpInfo(string, string2);
        return apiResponse.getData();
    }

    public ApiResponse<InputDisplayInfo> getInputMetadataWithHttpInfo(String string, String string2) throws ApiException {
        Call call = this.getInputMetadataValidateBeforeCall(string, string2, null, null);
        Type type = new TypeToken<InputDisplayInfo>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getInputMetadataAsync(String string, String string2, final ApiCallback<InputDisplayInfo> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getInputMetadataValidateBeforeCall(string, string2, progressListener, progressRequestListener);
        Type type = new TypeToken<InputDisplayInfo>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call queryAnalysisPrepStateCall(String string, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string2 = "/api/analysis-prep/{prep-id}".replaceAll("\\{prep-id\\}", this.apiClient.escapeString(string.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderAccept(stringArray);
        if (string3 != null) {
            hashMap.put("Accept", string3);
        }
        String[] stringArray2 = new String[]{};
        String string4 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string4);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string2, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call queryAnalysisPrepStateValidateBeforeCall(String string, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (string == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling queryAnalysisPrepState(Async)");
        }
        Call call = this.queryAnalysisPrepStateCall(string, progressListener, progressRequestListener);
        return call;
    }

    public AnalysisQueryResponse queryAnalysisPrepState(String string) throws ApiException {
        ApiResponse<AnalysisQueryResponse> apiResponse = this.queryAnalysisPrepStateWithHttpInfo(string);
        return apiResponse.getData();
    }

    public ApiResponse<AnalysisQueryResponse> queryAnalysisPrepStateWithHttpInfo(String string) throws ApiException {
        Call call = this.queryAnalysisPrepStateValidateBeforeCall(string, null, null);
        Type type = new TypeToken<AnalysisQueryResponse>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call queryAnalysisPrepStateAsync(String string, final ApiCallback<AnalysisQueryResponse> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.queryAnalysisPrepStateValidateBeforeCall(string, progressListener, progressRequestListener);
        Type type = new TypeToken<AnalysisQueryResponse>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call runPreparedAnalysisCall(String string, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string2 = "/api/analysis-prep/{prep-id}/analyze".replaceAll("\\{prep-id\\}", this.apiClient.escapeString(string.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string3 = this.apiClient.selectHeaderAccept(stringArray);
        if (string3 != null) {
            hashMap.put("Accept", string3);
        }
        String[] stringArray2 = new String[]{};
        String string4 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string4);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string2, "POST", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call runPreparedAnalysisValidateBeforeCall(String string, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (string == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling runPreparedAnalysis(Async)");
        }
        Call call = this.runPreparedAnalysisCall(string, progressListener, progressRequestListener);
        return call;
    }

    public Analysis runPreparedAnalysis(String string) throws ApiException {
        ApiResponse<Analysis> apiResponse = this.runPreparedAnalysisWithHttpInfo(string);
        return apiResponse.getData();
    }

    public ApiResponse<Analysis> runPreparedAnalysisWithHttpInfo(String string) throws ApiException {
        Call call = this.runPreparedAnalysisValidateBeforeCall(string, null, null);
        Type type = new TypeToken<Analysis>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call runPreparedAnalysisAsync(String string, final ApiCallback<Analysis> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.runPreparedAnalysisValidateBeforeCall(string, progressListener, progressRequestListener);
        Type type = new TypeToken<Analysis>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call setAnalysisNameCall(Integer n, Integer n2, AnalysisName analysisName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AnalysisName analysisName2 = analysisName;
        String string = "/api/projects/{project-id}/analyses/{analysis-id}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{analysis-id\\}", this.apiClient.escapeString(n2.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, analysisName2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call setAnalysisNameValidateBeforeCall(Integer n, Integer n2, AnalysisName analysisName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling setAnalysisName(Async)");
        }
        if (n2 == null) {
            throw new ApiException("Missing the required parameter 'analysisId' when calling setAnalysisName(Async)");
        }
        Call call = this.setAnalysisNameCall(n, n2, analysisName, progressListener, progressRequestListener);
        return call;
    }

    public void setAnalysisName(Integer n, Integer n2, AnalysisName analysisName) throws ApiException {
        this.setAnalysisNameWithHttpInfo(n, n2, analysisName);
    }

    public ApiResponse<Void> setAnalysisNameWithHttpInfo(Integer n, Integer n2, AnalysisName analysisName) throws ApiException {
        Call call = this.setAnalysisNameValidateBeforeCall(n, n2, analysisName, null, null);
        return this.apiClient.execute(call);
    }

    public Call setAnalysisNameAsync(Integer n, Integer n2, AnalysisName analysisName, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.setAnalysisNameValidateBeforeCall(n, n2, analysisName, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call setDisplayTagCall(String string, String string2, String string3, Enabled enabled, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Enabled enabled2 = enabled;
        String string4 = "/api/analysis-prep/{prep-id}/{input-id}/tag/{tag-id}".replaceAll("\\{prep-id\\}", this.apiClient.escapeString(string.toString())).replaceAll("\\{input-id\\}", this.apiClient.escapeString(string2.toString())).replaceAll("\\{tag-id\\}", this.apiClient.escapeString(string3.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string5 = this.apiClient.selectHeaderAccept(stringArray);
        if (string5 != null) {
            hashMap.put("Accept", string5);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string6 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string6);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string4, "PUT", arrayList, arrayList2, enabled2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call setDisplayTagValidateBeforeCall(String string, String string2, String string3, Enabled enabled, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (string == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling setDisplayTag(Async)");
        }
        if (string2 == null) {
            throw new ApiException("Missing the required parameter 'inputId' when calling setDisplayTag(Async)");
        }
        if (string3 == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling setDisplayTag(Async)");
        }
        Call call = this.setDisplayTagCall(string, string2, string3, enabled, progressListener, progressRequestListener);
        return call;
    }

    public InputDisplayInfo setDisplayTag(String string, String string2, String string3, Enabled enabled) throws ApiException {
        ApiResponse<InputDisplayInfo> apiResponse = this.setDisplayTagWithHttpInfo(string, string2, string3, enabled);
        return apiResponse.getData();
    }

    public ApiResponse<InputDisplayInfo> setDisplayTagWithHttpInfo(String string, String string2, String string3, Enabled enabled) throws ApiException {
        Call call = this.setDisplayTagValidateBeforeCall(string, string2, string3, enabled, null, null);
        Type type = new TypeToken<InputDisplayInfo>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call setDisplayTagAsync(String string, String string2, String string3, Enabled enabled, final ApiCallback<InputDisplayInfo> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.setDisplayTagValidateBeforeCall(string, string2, string3, enabled, progressListener, progressRequestListener);
        Type type = new TypeToken<InputDisplayInfo>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call uploadFileCall(String string, File file, String string2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] stringArray;
        String string3;
        Object var6_6 = null;
        String string4 = "/api/analysis-prep/{prep-id}/upload".replaceAll("\\{prep-id\\}", this.apiClient.escapeString(string.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string2 != null) {
            hashMap.put("X-Client-Request-Id", this.apiClient.parameterToString(string2));
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        if (file != null) {
            hashMap2.put("file", file);
        }
        if ((string3 = this.apiClient.selectHeaderAccept(stringArray = new String[0])) != null) {
            hashMap.put("Accept", string3);
        }
        String[] stringArray2 = new String[]{"multipart/form-data"};
        String string5 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string5);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string4, "POST", arrayList, arrayList2, var6_6, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call uploadFileValidateBeforeCall(String string, File file, String string2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (string == null) {
            throw new ApiException("Missing the required parameter 'prepId' when calling uploadFile(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadFile(Async)");
        }
        Call call = this.uploadFileCall(string, file, string2, progressListener, progressRequestListener);
        return call;
    }

    public FileUploadResponse uploadFile(String string, File file, String string2) throws ApiException {
        ApiResponse<FileUploadResponse> apiResponse = this.uploadFileWithHttpInfo(string, file, string2);
        return apiResponse.getData();
    }

    public ApiResponse<FileUploadResponse> uploadFileWithHttpInfo(String string, File file, String string2) throws ApiException {
        Call call = this.uploadFileValidateBeforeCall(string, file, string2, null, null);
        Type type = new TypeToken<FileUploadResponse>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call uploadFileAsync(String string, File file, String string2, final ApiCallback<FileUploadResponse> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.uploadFileValidateBeforeCall(string, file, string2, progressListener, progressRequestListener);
        Type type = new TypeToken<FileUploadResponse>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }
}

