/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;
import com.codedx.client.model.CreateUser;
import com.codedx.client.model.DisableUser;
import com.codedx.client.model.Password;
import com.codedx.client.model.User;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UserAdministrationApi {
    private ApiClient apiClient;

    public UserAdministrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserAdministrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call changeUserPasswordCall(Integer n, Password password, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Password password2 = password;
        String string = "/api/admin/users/local/{user-id}/password".replaceAll("\\{user-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, password2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call changeUserPasswordValidateBeforeCall(Integer n, Password password, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling changeUserPassword(Async)");
        }
        Call call = this.changeUserPasswordCall(n, password, progressListener, progressRequestListener);
        return call;
    }

    public void changeUserPassword(Integer n, Password password) throws ApiException {
        this.changeUserPasswordWithHttpInfo(n, password);
    }

    public ApiResponse<Void> changeUserPasswordWithHttpInfo(Integer n, Password password) throws ApiException {
        Call call = this.changeUserPasswordValidateBeforeCall(n, password, null, null);
        return this.apiClient.execute(call);
    }

    public Call changeUserPasswordAsync(Integer n, Password password, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.changeUserPasswordValidateBeforeCall(n, password, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call createExternalUserCall(CreateUser createUser, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateUser createUser2 = createUser;
        String string = "/api/admin/users/external";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, createUser2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createExternalUserValidateBeforeCall(CreateUser createUser, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createExternalUserCall(createUser, progressListener, progressRequestListener);
        return call;
    }

    public User createExternalUser(CreateUser createUser) throws ApiException {
        ApiResponse<User> apiResponse = this.createExternalUserWithHttpInfo(createUser);
        return apiResponse.getData();
    }

    public ApiResponse<User> createExternalUserWithHttpInfo(CreateUser createUser) throws ApiException {
        Call call = this.createExternalUserValidateBeforeCall(createUser, null, null);
        Type type = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createExternalUserAsync(CreateUser createUser, final ApiCallback<User> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createExternalUserValidateBeforeCall(createUser, progressListener, progressRequestListener);
        Type type = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call createKeyUserCall(CreateUser createUser, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateUser createUser2 = createUser;
        String string = "/api/admin/users/key";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, createUser2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createKeyUserValidateBeforeCall(CreateUser createUser, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createKeyUserCall(createUser, progressListener, progressRequestListener);
        return call;
    }

    public User createKeyUser(CreateUser createUser) throws ApiException {
        ApiResponse<User> apiResponse = this.createKeyUserWithHttpInfo(createUser);
        return apiResponse.getData();
    }

    public ApiResponse<User> createKeyUserWithHttpInfo(CreateUser createUser) throws ApiException {
        Call call = this.createKeyUserValidateBeforeCall(createUser, null, null);
        Type type = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createKeyUserAsync(CreateUser createUser, final ApiCallback<User> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createKeyUserValidateBeforeCall(createUser, progressListener, progressRequestListener);
        Type type = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call createLdapUserCall(CreateUser createUser, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateUser createUser2 = createUser;
        String string = "/api/admin/users/ldap";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, createUser2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createLdapUserValidateBeforeCall(CreateUser createUser, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createLdapUserCall(createUser, progressListener, progressRequestListener);
        return call;
    }

    public User createLdapUser(CreateUser createUser) throws ApiException {
        ApiResponse<User> apiResponse = this.createLdapUserWithHttpInfo(createUser);
        return apiResponse.getData();
    }

    public ApiResponse<User> createLdapUserWithHttpInfo(CreateUser createUser) throws ApiException {
        Call call = this.createLdapUserValidateBeforeCall(createUser, null, null);
        Type type = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createLdapUserAsync(CreateUser createUser, final ApiCallback<User> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createLdapUserValidateBeforeCall(createUser, progressListener, progressRequestListener);
        Type type = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call createLocalUserCall(CreateUser createUser, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateUser createUser2 = createUser;
        String string = "/api/admin/users/local";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, createUser2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call createLocalUserValidateBeforeCall(CreateUser createUser, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createLocalUserCall(createUser, progressListener, progressRequestListener);
        return call;
    }

    public User createLocalUser(CreateUser createUser) throws ApiException {
        ApiResponse<User> apiResponse = this.createLocalUserWithHttpInfo(createUser);
        return apiResponse.getData();
    }

    public ApiResponse<User> createLocalUserWithHttpInfo(CreateUser createUser) throws ApiException {
        Call call = this.createLocalUserValidateBeforeCall(createUser, null, null);
        Type type = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call createLocalUserAsync(CreateUser createUser, final ApiCallback<User> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.createLocalUserValidateBeforeCall(createUser, progressListener, progressRequestListener);
        Type type = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call deleteUserCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/admin/users/{user-id}".replaceAll("\\{user-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[0];
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "DELETE", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call deleteUserValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUser(Async)");
        }
        Call call = this.deleteUserCall(n, progressListener, progressRequestListener);
        return call;
    }

    public void deleteUser(Integer n) throws ApiException {
        this.deleteUserWithHttpInfo(n);
    }

    public ApiResponse<Void> deleteUserWithHttpInfo(Integer n) throws ApiException {
        Call call = this.deleteUserValidateBeforeCall(n, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteUserAsync(Integer n, final ApiCallback<Void> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.deleteUserValidateBeforeCall(n, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, apiCallback);
        return call;
    }

    public Call getAllUsersCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/admin/users";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getAllUsersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllUsersCall(progressListener, progressRequestListener);
        return call;
    }

    public List<User> getAllUsers() throws ApiException {
        ApiResponse<List<User>> apiResponse = this.getAllUsersWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<User>> getAllUsersWithHttpInfo() throws ApiException {
        Call call = this.getAllUsersValidateBeforeCall(null, null);
        Type type = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getAllUsersAsync(final ApiCallback<List<User>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getAllUsersValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getExternalUsersCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/admin/users/external";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getExternalUsersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getExternalUsersCall(progressListener, progressRequestListener);
        return call;
    }

    public List<User> getExternalUsers() throws ApiException {
        ApiResponse<List<User>> apiResponse = this.getExternalUsersWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<User>> getExternalUsersWithHttpInfo() throws ApiException {
        Call call = this.getExternalUsersValidateBeforeCall(null, null);
        Type type = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getExternalUsersAsync(final ApiCallback<List<User>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getExternalUsersValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getKeyUsersCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/admin/users/key";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getKeyUsersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getKeyUsersCall(progressListener, progressRequestListener);
        return call;
    }

    public List<User> getKeyUsers() throws ApiException {
        ApiResponse<List<User>> apiResponse = this.getKeyUsersWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<User>> getKeyUsersWithHttpInfo() throws ApiException {
        Call call = this.getKeyUsersValidateBeforeCall(null, null);
        Type type = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getKeyUsersAsync(final ApiCallback<List<User>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getKeyUsersValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getLdapUsersCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/admin/users/ldap";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getLdapUsersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getLdapUsersCall(progressListener, progressRequestListener);
        return call;
    }

    public List<User> getLdapUsers() throws ApiException {
        ApiResponse<List<User>> apiResponse = this.getLdapUsersWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<User>> getLdapUsersWithHttpInfo() throws ApiException {
        Call call = this.getLdapUsersValidateBeforeCall(null, null);
        Type type = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getLdapUsersAsync(final ApiCallback<List<User>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getLdapUsersValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getLocalUsersCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var3_3 = null;
        String string = "/api/admin/users/local";
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var3_3, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getLocalUsersValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getLocalUsersCall(progressListener, progressRequestListener);
        return call;
    }

    public List<User> getLocalUsers() throws ApiException {
        ApiResponse<List<User>> apiResponse = this.getLocalUsersWithHttpInfo();
        return apiResponse.getData();
    }

    public ApiResponse<List<User>> getLocalUsersWithHttpInfo() throws ApiException {
        Call call = this.getLocalUsersValidateBeforeCall(null, null);
        Type type = new TypeToken<List<User>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getLocalUsersAsync(final ApiCallback<List<User>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getLocalUsersValidateBeforeCall(progressListener, progressRequestListener);
        Type type = new TypeToken<List<User>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call modifyUserCall(Integer n, DisableUser disableUser, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DisableUser disableUser2 = disableUser;
        String string = "/api/admin/users/{user-id}".replaceAll("\\{user-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "PUT", arrayList, arrayList2, disableUser2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call modifyUserValidateBeforeCall(Integer n, DisableUser disableUser, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling modifyUser(Async)");
        }
        Call call = this.modifyUserCall(n, disableUser, progressListener, progressRequestListener);
        return call;
    }

    public User modifyUser(Integer n, DisableUser disableUser) throws ApiException {
        ApiResponse<User> apiResponse = this.modifyUserWithHttpInfo(n, disableUser);
        return apiResponse.getData();
    }

    public ApiResponse<User> modifyUserWithHttpInfo(Integer n, DisableUser disableUser) throws ApiException {
        Call call = this.modifyUserValidateBeforeCall(n, disableUser, null, null);
        Type type = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call modifyUserAsync(Integer n, DisableUser disableUser, final ApiCallback<User> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.modifyUserValidateBeforeCall(n, disableUser, progressListener, progressRequestListener);
        Type type = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call regenerateApiKeyCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/admin/users/key/{user-id}/regenerate".replaceAll("\\{user-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "POST", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call regenerateApiKeyValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling regenerateApiKey(Async)");
        }
        Call call = this.regenerateApiKeyCall(n, progressListener, progressRequestListener);
        return call;
    }

    public User regenerateApiKey(Integer n) throws ApiException {
        ApiResponse<User> apiResponse = this.regenerateApiKeyWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<User> regenerateApiKeyWithHttpInfo(Integer n) throws ApiException {
        Call call = this.regenerateApiKeyValidateBeforeCall(n, null, null);
        Type type = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call regenerateApiKeyAsync(Integer n, final ApiCallback<User> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.regenerateApiKeyValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }
}

