/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class DisplayTagState {
    @SerializedName(value="source")
    private String source = null;
    @SerializedName(value="binary")
    private String binary = null;
    @SerializedName(value="buildMeta")
    private String buildMeta = null;
    @SerializedName(value="toolOutput")
    private String toolOutput = null;
    @SerializedName(value="toolInput")
    private String toolInput = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="enabled")
    private Boolean enabled = null;
    @SerializedName(value="enabledReason")
    private String enabledReason = null;

    public DisplayTagState source(String string) {
        this.source = string;
        return this;
    }

    @ApiModelProperty(value="if the file appears to be a zip file that includes source files, the value of this field will be the name of the language of that source (e.g. \"C#\")")
    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public DisplayTagState binary(String string) {
        this.binary = string;
        return this;
    }

    @ApiModelProperty(value="if the file appears to be a zip file that includes compiled \"binary\" files, the value of this field will be the name of the platform on which they run (e.g. \"CLR\")")
    public String getBinary() {
        return this.binary;
    }

    public void setBinary(String string) {
        this.binary = string;
    }

    public DisplayTagState buildMeta(String string) {
        this.buildMeta = string;
        return this;
    }

    @ApiModelProperty(value="if the file appears to be a zip file that includes some kind of build metadata (e.g. an npm package.json file), the value of this field will be a string describing what type of file was found")
    public String getBuildMeta() {
        return this.buildMeta;
    }

    public void setBuildMeta(String string) {
        this.buildMeta = string;
    }

    public DisplayTagState toolOutput(String string) {
        this.toolOutput = string;
        return this;
    }

    @ApiModelProperty(value="if the file appears to be an output of a tool (i.e. a file containing Findings), the value of this field will be the name of that tool.")
    public String getToolOutput() {
        return this.toolOutput;
    }

    public void setToolOutput(String string) {
        this.toolOutput = string;
    }

    public DisplayTagState toolInput(String string) {
        this.toolInput = string;
        return this;
    }

    @ApiModelProperty(value="if the file appears to be usable as an input to a tool that Code Dx can automatically run, the value of this field will be that tool.")
    public String getToolInput() {
        return this.toolInput;
    }

    public void setToolInput(String string) {
        this.toolInput = string;
    }

    public DisplayTagState id(String string) {
        this.id = string;
        return this;
    }

    @ApiModelProperty(value="a semi-random identifier which can be assumed to be unique within the context of an Analysis Prep. This identifier can be used when constructing URLs to interact with a specific Display Tag State.")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public DisplayTagState enabled(Boolean bl) {
        this.enabled = bl;
        return this;
    }

    @ApiModelProperty(value="a boolean, indicating whether the tag is enabled. If not enabled, the content described by the tag will be treated as if it wasn't there. In the case of toolInput, that could mean that the particular tool would not be run.")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean bl) {
        this.enabled = bl;
    }

    public DisplayTagState enabledReason(String string) {
        this.enabledReason = string;
        return this;
    }

    @ApiModelProperty(value="a string, either \"user\", or \"rule-config\". If the associated project has disabled a particular tool by configuration, toolInput tags for that tool will be disabled by \"rule-config\". If the API is used to enable or disable a tag, it will be disabled by \"user\".")
    public String getEnabledReason() {
        return this.enabledReason;
    }

    public void setEnabledReason(String string) {
        this.enabledReason = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DisplayTagState displayTagState = (DisplayTagState)object;
        return Objects.equals(this.source, displayTagState.source) && Objects.equals(this.binary, displayTagState.binary) && Objects.equals(this.buildMeta, displayTagState.buildMeta) && Objects.equals(this.toolOutput, displayTagState.toolOutput) && Objects.equals(this.toolInput, displayTagState.toolInput) && Objects.equals(this.id, displayTagState.id) && Objects.equals(this.enabled, displayTagState.enabled) && Objects.equals(this.enabledReason, displayTagState.enabledReason);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.binary, this.buildMeta, this.toolOutput, this.toolInput, this.id, this.enabled, this.enabledReason);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class DisplayTagState {\n");
        stringBuilder.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        stringBuilder.append("    binary: ").append(this.toIndentedString(this.binary)).append("\n");
        stringBuilder.append("    buildMeta: ").append(this.toIndentedString(this.buildMeta)).append("\n");
        stringBuilder.append("    toolOutput: ").append(this.toIndentedString(this.toolOutput)).append("\n");
        stringBuilder.append("    toolInput: ").append(this.toIndentedString(this.toolInput)).append("\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        stringBuilder.append("    enabledReason: ").append(this.toIndentedString(this.enabledReason)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

