/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.model;

import com.codedx.client.model.ScmInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An optional object which, if present, describes the automatically-created \"SCM Input\" to the analyses, e.g. source pulled from Git.")
public class ScmSetup {
    @SerializedName(value="scmInfo")
    private ScmInfo scmInfo = null;
    @SerializedName(value="inputId")
    private String inputId = null;
    @SerializedName(value="setupJobId")
    private String setupJobId = null;

    public ScmSetup scmInfo(ScmInfo scmInfo) {
        this.scmInfo = scmInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ScmInfo getScmInfo() {
        return this.scmInfo;
    }

    public void setScmInfo(ScmInfo scmInfo) {
        this.scmInfo = scmInfo;
    }

    public ScmSetup inputId(String string) {
        this.inputId = string;
        return this;
    }

    @ApiModelProperty(value="the ID for the \"SCM Input\", which should be used when constructing URLs for interacting with this input.")
    public String getInputId() {
        return this.inputId;
    }

    public void setInputId(String string) {
        this.inputId = string;
    }

    public ScmSetup setupJobId(String string) {
        this.setupJobId = string;
        return this;
    }

    @ApiModelProperty(value="a job ID. The setup process for an SCM Input can take some time, so the setup job should be monitored via the Job System. Once the job is complete, the content of the repository will be ready to analyze.")
    public String getSetupJobId() {
        return this.setupJobId;
    }

    public void setSetupJobId(String string) {
        this.setupJobId = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScmSetup scmSetup = (ScmSetup)object;
        return Objects.equals(this.scmInfo, scmSetup.scmInfo) && Objects.equals(this.inputId, scmSetup.inputId) && Objects.equals(this.setupJobId, scmSetup.setupJobId);
    }

    public int hashCode() {
        return Objects.hash(this.scmInfo, this.inputId, this.setupJobId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ScmSetup {\n");
        stringBuilder.append("    scmInfo: ").append(this.toIndentedString(this.scmInfo)).append("\n");
        stringBuilder.append("    inputId: ").append(this.toIndentedString(this.inputId)).append("\n");
        stringBuilder.append("    setupJobId: ").append(this.toIndentedString(this.setupJobId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

