/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class User {
    @SerializedName(value="id")
    private Integer id = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="principal")
    private String principal = null;
    @SerializedName(value="isEnabled")
    private Boolean isEnabled = null;
    @SerializedName(value="isSystem")
    private Boolean isSystem = null;
    @SerializedName(value="isAdmin")
    private Boolean isAdmin = null;
    @SerializedName(value="isCurrent")
    private Boolean isCurrent = null;

    public User id(Integer n) {
        this.id = n;
        return this;
    }

    @ApiModelProperty(value="The user's unique ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public User type(TypeEnum typeEnum) {
        this.type = typeEnum;
        return this;
    }

    @ApiModelProperty(value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum typeEnum) {
        this.type = typeEnum;
    }

    public User name(String string) {
        this.name = string;
        return this;
    }

    @ApiModelProperty(value="The user's display name")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public User principal(String string) {
        this.principal = string;
        return this;
    }

    @ApiModelProperty(value="The user's principal. For `local` and `ldap` users, this will be the same as the name. For `key` users, this will be the API Key")
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String string) {
        this.principal = string;
    }

    public User isEnabled(Boolean bl) {
        this.isEnabled = bl;
        return this;
    }

    @ApiModelProperty(value="Flag that states whether the user is \"enabled\" (disabled users may not log in, and don't count against your license)")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean bl) {
        this.isEnabled = bl;
    }

    public User isSystem(Boolean bl) {
        this.isSystem = bl;
        return this;
    }

    @ApiModelProperty(value="Flag indicating whether the user is the Code Dx \"system\" user. This will only be true for the user you set up during installation")
    public Boolean isIsSystem() {
        return this.isSystem;
    }

    public void setIsSystem(Boolean bl) {
        this.isSystem = bl;
    }

    public User isAdmin(Boolean bl) {
        this.isAdmin = bl;
        return this;
    }

    @ApiModelProperty(value="Flag indicating whether the user has the `admin` role.")
    public Boolean isIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean bl) {
        this.isAdmin = bl;
    }

    public User isCurrent(Boolean bl) {
        this.isCurrent = bl;
        return this;
    }

    @ApiModelProperty(value="Flag indicating whether the user is the same as the one currently logged-in to make the request. In other words, this user is \"you\".")
    public Boolean isIsCurrent() {
        return this.isCurrent;
    }

    public void setIsCurrent(Boolean bl) {
        this.isCurrent = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        User user = (User)object;
        return Objects.equals(this.id, user.id) && Objects.equals((Object)this.type, (Object)user.type) && Objects.equals(this.name, user.name) && Objects.equals(this.principal, user.principal) && Objects.equals(this.isEnabled, user.isEnabled) && Objects.equals(this.isSystem, user.isSystem) && Objects.equals(this.isAdmin, user.isAdmin) && Objects.equals(this.isCurrent, user.isCurrent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.name, this.principal, this.isEnabled, this.isSystem, this.isAdmin, this.isCurrent});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class User {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        stringBuilder.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        stringBuilder.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        stringBuilder.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        stringBuilder.append("    isSystem: ").append(this.toIndentedString(this.isSystem)).append("\n");
        stringBuilder.append("    isAdmin: ").append(this.toIndentedString(this.isAdmin)).append("\n");
        stringBuilder.append("    isCurrent: ").append(this.toIndentedString(this.isCurrent)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        LOCAL("local"),
        LDAP("ldap"),
        KEY("key"),
        EXTERNAL("external");

        private String value;

        private TypeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String string) {
            for (TypeEnum typeEnum : TypeEnum.values()) {
                if (!String.valueOf(typeEnum.value).equals(string)) continue;
                return typeEnum;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum typeEnum) throws IOException {
                jsonWriter.value(typeEnum.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(string));
            }
        }
    }
}

