/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import jep.ClassEnquirer;
import jep.ClassList;
import jep.JepConfig;
import jep.JepException;
import jep.PyConfig;
import jep.Util;
import jep.python.PyModule;
import jep.python.PyObject;

public final class Jep
implements Closeable {
    private static final String THREAD_WARN = "JEP THREAD WARNING: ";
    private static TopInterpreter topInterpreter = null;
    private static String[] sharedModulesArgv = null;
    private boolean closed = false;
    private long tstate = 0L;
    private Thread thread = null;
    private ClassLoader classLoader = null;
    private StringBuilder evalLines = null;
    private boolean interactive = false;
    private static final String LINE_SEP = "\n";
    private final List<PyObject> pythonObjects = new ArrayList<PyObject>();
    private static final ThreadLocal<Boolean> threadUsed = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static void setInitParams(PyConfig pyConfig) throws JepException {
        if (null != topInterpreter) {
            throw new JepException("Jep.setInitParams called after initializing python interpreter.");
        }
        Jep.setInitParams(pyConfig.noSiteFlag, pyConfig.noUserSiteDirectory, pyConfig.ignoreEnvironmentFlag, pyConfig.verboseFlag, pyConfig.optimizeFlag, pyConfig.dontWriteBytecodeFlag, pyConfig.hashRandomizationFlag);
    }

    public static void setSharedModulesArgv(String ... stringArray) throws JepException {
        if (topInterpreter != null) {
            throw new JepException("Jep.setSharedModulesArgv called after initializing python interpreter.");
        }
        sharedModulesArgv = stringArray;
    }

    private static native void setInitParams(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    private static native void initializePython(String[] var0);

    private static native void sharedImport(String var0) throws JepException;

    private static synchronized void createTopInterpreter() throws Error {
        if (null == topInterpreter) {
            try {
                topInterpreter = new TopInterpreter();
                Jep.topInterpreter.initialize();
            }
            catch (Error error) {
                topInterpreter.close();
                throw error;
            }
        } else if (null != Jep.topInterpreter.error) {
            throw new Error("The main python interpreter previously failed to initialize.", Jep.topInterpreter.error);
        }
    }

    public Jep() throws JepException {
        this(false, null, null);
    }

    public Jep(boolean bl) throws JepException {
        this(bl, null, null);
    }

    public Jep(boolean bl, String string) throws JepException {
        this(bl, string, null);
    }

    public Jep(boolean bl, String string, ClassLoader classLoader) throws JepException {
        this(bl, string, classLoader, null);
    }

    public Jep(boolean bl, String string, ClassLoader classLoader, ClassEnquirer classEnquirer) throws JepException {
        this(new JepConfig().setInteractive(bl).setIncludePath(string).setClassLoader(classLoader).setClassEnquirer(classEnquirer));
    }

    public Jep(JepConfig jepConfig) throws JepException {
        Object object;
        Jep.createTopInterpreter();
        if (threadUsed.get().booleanValue()) {
            Thread thread = Thread.currentThread();
            object = new StringBuilder(THREAD_WARN).append("Unsafe reuse of thread ").append(thread.getName()).append(" for another Python sub-interpreter.\n").append("Please close() the previous Jep instance to ensure stability.");
            System.err.println(((StringBuilder)object).toString());
        }
        this.classLoader = jepConfig.classLoader == null ? this.getClass().getClassLoader() : jepConfig.classLoader;
        boolean bl = jepConfig.sharedModules != null && !jepConfig.sharedModules.isEmpty();
        this.interactive = jepConfig.interactive;
        this.tstate = this.init(this.classLoader, bl);
        threadUsed.set(true);
        this.thread = Thread.currentThread();
        if (jepConfig.includePath != null) {
            object = jepConfig.includePath.toString();
            if (((String)object).contains("\\")) {
                object = ((String)object).replace("\\", "\\\\");
            }
            this.eval("import sys");
            this.eval("sys.path += '" + (String)object + "'.split('" + File.pathSeparator + "')");
        }
        this.eval("import jep");
        if (bl) {
            this.set("sharedModules", jepConfig.sharedModules);
            this.set("sharedImporter", topInterpreter);
            this.eval("jep.shared_modules_hook.setupImporter(sharedModules,sharedImporter)");
            this.eval("del sharedModules");
            this.eval("del sharedImporter");
            this.eval(null);
        }
        if ((object = jepConfig.classEnquirer) == null) {
            object = ClassList.getInstance();
        }
        this.set("classlist", object);
        this.eval("jep.java_import_hook.setupImporter(classlist)");
        this.eval("del classlist");
        this.eval(null);
        if (jepConfig.redirectOutputStreams) {
            this.eval("from jep import redirect_streams");
            this.eval("redirect_streams.setup()");
            this.eval(null);
        }
    }

    private native long init(ClassLoader var1, boolean var2) throws JepException;

    public void isValidThread() throws JepException {
        if (this.thread != Thread.currentThread()) {
            throw new JepException("Invalid thread access.");
        }
        if (this.closed) {
            throw new JepException("Jep instance has been closed.");
        }
        if (this.tstate == 0L) {
            throw new JepException("Initialization failed.");
        }
    }

    public void runScript(String string) throws JepException {
        this.runScript(string, null);
    }

    public void runScript(String string, ClassLoader classLoader) throws JepException {
        this.isValidThread();
        if (string == null) {
            throw new JepException("Script filename cannot be null.");
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new JepException("Invalid file: " + file.getAbsolutePath());
        }
        this.setClassLoader(classLoader);
        this.run(this.tstate, string);
    }

    private native void run(long var1, String var3) throws JepException;

    public Object invoke(String string, Object ... objectArray) throws JepException {
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = Util.getTypeId(objectArray[i]);
        }
        return this.invoke(this.tstate, string, objectArray, nArray);
    }

    private native Object invoke(long var1, String var3, Object[] var4, int[] var5);

    public boolean eval(String string) throws JepException {
        this.isValidThread();
        try {
            if (string != null) {
                string = string.replaceAll("\r", "");
            }
            if (string == null || string.trim().equals("")) {
                if (!this.interactive) {
                    return false;
                }
                if (this.evalLines == null) {
                    return true;
                }
                this.eval(this.tstate, this.evalLines.toString());
                this.evalLines = null;
                return true;
            }
            if (!this.interactive || this.evalLines == null && this.compileString(this.tstate, string) == 1) {
                this.eval(this.tstate, string);
                return true;
            }
            if (this.evalLines == null) {
                this.evalLines = new StringBuilder();
            } else {
                this.evalLines.append(LINE_SEP);
            }
            this.evalLines.append(string);
            return false;
        }
        catch (JepException jepException) {
            this.evalLines = null;
            throw jepException;
        }
    }

    private native int compileString(long var1, String var3) throws JepException;

    private native void eval(long var1, String var3) throws JepException;

    public Object getValue(String string) throws JepException {
        this.isValidThread();
        return this.getValue(this.tstate, string);
    }

    private native Object getValue(long var1, String var3) throws JepException;

    public byte[] getValue_bytearray(String string) throws JepException {
        this.isValidThread();
        return this.getValue_bytearray(this.tstate, string);
    }

    private native byte[] getValue_bytearray(long var1, String var3) throws JepException;

    public PyObject trackObject(PyObject pyObject) throws JepException {
        return this.trackObject(pyObject, true);
    }

    public PyObject trackObject(PyObject pyObject, boolean bl) throws JepException {
        if (bl) {
            pyObject.incref();
        }
        this.pythonObjects.add(pyObject);
        return pyObject;
    }

    public PyModule createModule(String string) throws JepException {
        return (PyModule)this.trackObject(new PyModule(this.tstate, this.createModule(this.tstate, string), this));
    }

    private native long createModule(long var1, String var3) throws JepException;

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null && classLoader != this.classLoader) {
            this.classLoader = classLoader;
            this.setClassLoader(this.tstate, classLoader);
        }
    }

    private native void setClassLoader(long var1, ClassLoader var3);

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void set(String string, Object object) throws JepException {
        this.isValidThread();
        if (object instanceof Class) {
            this.set(this.tstate, string, (Class)object);
        } else if (object instanceof String) {
            this.set(string, (String)object);
        } else if (object instanceof Float) {
            this.set(string, ((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.set(string, (Integer)object);
        } else if (object instanceof Double) {
            this.set(string, (Double)object);
        } else if (object instanceof Long) {
            this.set(string, (Long)object);
        } else if (object instanceof Byte) {
            this.set(string, (Byte)object);
        } else if (object instanceof Short) {
            this.set(string, (Short)object);
        } else if (object instanceof Boolean) {
            this.set(string, (Boolean)object);
        } else {
            this.set(this.tstate, string, object);
        }
    }

    private native void set(long var1, String var3, Object var4) throws JepException;

    private native void set(long var1, String var3, Class<?> var4) throws JepException;

    public void set(String string, String string2) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, string2);
    }

    private native void set(long var1, String var3, String var4) throws JepException;

    public void set(String string, boolean bl) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, bl);
    }

    private native void set(long var1, String var3, boolean var4) throws JepException;

    public void set(String string, int n) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, n);
    }

    public void set(String string, short s) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, s);
    }

    private native void set(long var1, String var3, int var4) throws JepException;

    public void set(String string, char[] cArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, new String(cArray));
    }

    public void set(String string, char c) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, new String(new char[]{c}));
    }

    public void set(String string, byte by) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, by);
    }

    public void set(String string, long l) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, l);
    }

    private native void set(long var1, String var3, long var4) throws JepException;

    public void set(String string, double d) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, d);
    }

    private native void set(long var1, String var3, double var4) throws JepException;

    public void set(String string, float f) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, f);
    }

    private native void set(long var1, String var3, float var4) throws JepException;

    public void set(String string, boolean[] blArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, blArray);
    }

    private native void set(long var1, String var3, boolean[] var4) throws JepException;

    public void set(String string, int[] nArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, nArray);
    }

    private native void set(long var1, String var3, int[] var4) throws JepException;

    public void set(String string, short[] sArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, sArray);
    }

    private native void set(long var1, String var3, short[] var4) throws JepException;

    public void set(String string, byte[] byArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, byArray);
    }

    private native void set(long var1, String var3, byte[] var4) throws JepException;

    public void set(String string, long[] lArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, lArray);
    }

    private native void set(long var1, String var3, long[] var4) throws JepException;

    public void set(String string, double[] dArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, dArray);
    }

    private native void set(long var1, String var3, double[] var4) throws JepException;

    public void set(String string, float[] fArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, fArray);
    }

    private native void set(long var1, String var3, float[] var4) throws JepException;

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (!Thread.currentThread().equals(this.thread)) {
            Thread thread = Thread.currentThread();
            StringBuilder stringBuilder = new StringBuilder(THREAD_WARN).append("Unsafe close() of Python sub-interpreter by thread ").append(thread.getName()).append(".\nPlease close() from the creating thread to ensure stability.");
            System.err.println(stringBuilder);
        }
        this.closed = true;
        for (int i = 0; i < this.pythonObjects.size(); ++i) {
            this.pythonObjects.get(i).close();
        }
        try {
            this.eval(this.tstate, "import jep");
            this.eval(this.tstate, "jep.shared_modules_hook.teardownImporter()");
        }
        catch (JepException jepException) {
            throw new RuntimeException(jepException);
        }
        this.close(this.tstate);
        this.tstate = 0L;
        threadUsed.set(false);
    }

    private native void close(long var1);

    static {
        System.loadLibrary("jep");
    }

    private static class TopInterpreter
    implements AutoCloseable {
        Thread thread;
        BlockingQueue<String> importQueue = new SynchronousQueue<String>();
        BlockingQueue<Object> importResults = new SynchronousQueue<Object>();
        Throwable error;

        private TopInterpreter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() throws Error {
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    try {
                        Jep.initializePython(sharedModulesArgv);
                    }
                    catch (Throwable throwable) {
                        TopInterpreter.this.error = throwable;
                    }
                    finally {
                        object = TopInterpreter.this;
                        synchronized (object) {
                            TopInterpreter.this.notify();
                        }
                    }
                    try {
                        while (true) {
                            Object object2 = object = TopInterpreter.this.importQueue.take();
                            try {
                                Jep.sharedImport((String)object);
                            }
                            catch (JepException jepException) {
                                object2 = jepException;
                            }
                            TopInterpreter.this.importResults.put(object2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            });
            this.thread.setDaemon(true);
            TopInterpreter topInterpreter = this;
            synchronized (topInterpreter) {
                block6: {
                    this.thread.start();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.error == null) break block6;
                        this.error = interruptedException;
                    }
                }
            }
            if (this.error != null) {
                throw new Error(this.error);
            }
        }

        @Override
        public void close() {
            this.thread.interrupt();
        }

        public void sharedImport(String string) throws JepException {
            try {
                this.importQueue.put(string);
                Object object = this.importResults.take();
                if (object instanceof JepException) {
                    throw new JepException("Error importing shared module " + string, (JepException)object);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new JepException(interruptedException);
            }
        }
    }
}

