/*
 * Decompiled with CFR 0.152.
 */
package com.flagsmith;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flagsmith.FeatureUser;
import com.flagsmith.MapperFactory;
import java.io.IOException;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Trait
implements Serializable {
    private FeatureUser identity;
    @JsonProperty(value="trait_key")
    private String key;
    @JsonProperty(value="trait_value")
    private String value;

    @JsonIgnore
    public void parse(String data) throws IOException {
        ObjectMapper mapper = MapperFactory.getMappper();
        Trait prototype = (Trait)mapper.readValue(data, Trait.class);
        this.fromPrototype(prototype);
    }

    @JsonIgnore
    private void fromPrototype(Trait prototype) throws IOException {
        this.setKey(prototype.getKey());
        this.setValue(prototype.getValue());
    }

    @JsonIgnore
    public String toString() {
        ObjectMapper mapper = MapperFactory.getMappper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    public FeatureUser getIdentity() {
        return this.identity;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setIdentity(FeatureUser identity) {
        this.identity = identity;
    }

    @JsonProperty(value="trait_key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="trait_value")
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trait)) {
            return false;
        }
        Trait other = (Trait)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FeatureUser this$identity = this.getIdentity();
        FeatureUser other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !((Object)this$identity).equals(other$identity)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Trait;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FeatureUser $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : ((Object)$identity).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

