/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stats;

import com.zink.fly.stats.StatsBean;
import com.zink.fly.stub.StringCodec;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class StatsDecoder {
    private static final byte[] statsOp = new byte[]{-6, -78, 0, 9};
    private static final String EMPTY_STRING = "";
    private static final StringCodec codec = new StringCodec();

    public StatsBean[] stats(Socket socket) {
        return this.getStatsArray(socket, EMPTY_STRING);
    }

    public StatsBean stats(Socket socket, String string) {
        return this.getStatsArray(socket, string)[0];
    }

    public StatsBean[] getStatsArray(Socket socket, String string) {
        StatsBean[] statsBeanArray = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.write(statsOp);
            codec.writeString(dataOutputStream, string);
            return this.getStatsArray(dataInputStream);
        }
        catch (Exception exception) {
            return statsBeanArray;
        }
    }

    public StatsBean[] getStatsArray(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        StatsBean[] statsBeanArray = new StatsBean[(int)l];
        int n = 0;
        while ((long)n < l) {
            statsBeanArray[n] = StatsBean.makeBeanFromStream(dataInputStream);
            ++n;
        }
        return statsBeanArray;
    }
}

