/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class BundleHelper {
    private static final Map<String, String> methodSuffixNameByTypeName = new HashMap<String, String>();
    private AnnotationHelper annotationHelper;
    private boolean restoreCallNeedCastStatement = false;
    private boolean restoreCallNeedsSuppressWarning = false;
    private String methodNameToSave;
    private String methodNameToRestore;

    public BundleHelper(AnnotationHelper helper, Element element) {
        this.annotationHelper = helper;
        String typeString = ((Object)element.asType()).toString();
        TypeElement elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
        if (methodSuffixNameByTypeName.containsKey(typeString)) {
            this.methodNameToSave = "put" + methodSuffixNameByTypeName.get(typeString);
            this.methodNameToRestore = "get" + methodSuffixNameByTypeName.get(typeString);
        } else if (element.asType().getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)element.asType();
            boolean hasTypeArguments = false;
            if (arrayType.getComponentType() instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)arrayType.getComponentType();
                typeString = declaredType.asElement().toString();
                hasTypeArguments = declaredType.getTypeArguments().size() > 0;
            } else {
                typeString = ((Object)arrayType.getComponentType()).toString();
            }
            elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
            if (this.isTypeParcelable(elementType)) {
                this.methodNameToSave = "putParcelableArray";
                this.methodNameToRestore = "getParcelableArray";
                this.restoreCallNeedCastStatement = true;
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
            }
        } else {
            TypeMirror elementAsType = element.asType();
            boolean hasTypeArguments = false;
            if (elementAsType instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)elementAsType;
                typeString = declaredType.asElement().toString();
                elementType = this.annotationHelper.typeElementFromQualifiedName(typeString);
                boolean bl = hasTypeArguments = declaredType.getTypeArguments().size() > 0;
            }
            if (this.isTypeParcelable(elementType)) {
                this.methodNameToSave = "putParcelable";
                this.methodNameToRestore = "getParcelable";
            } else {
                this.methodNameToSave = "putSerializable";
                this.methodNameToRestore = "getSerializable";
                this.restoreCallNeedCastStatement = true;
                if (hasTypeArguments) {
                    this.restoreCallNeedsSuppressWarning = true;
                }
            }
        }
    }

    public boolean restoreCallNeedCastStatement() {
        return this.restoreCallNeedCastStatement;
    }

    public boolean restoreCallNeedsSuppressWarning() {
        return this.restoreCallNeedsSuppressWarning;
    }

    public String getMethodNameToSave() {
        return this.methodNameToSave;
    }

    public String getMethodNameToRestore() {
        return this.methodNameToRestore;
    }

    private boolean isTypeParcelable(TypeElement elementType) {
        TypeElement parcelableType = this.annotationHelper.typeElementFromQualifiedName("android.os.Parcelable");
        return elementType != null && this.annotationHelper.isSubtype(elementType, parcelableType);
    }

    static {
        methodSuffixNameByTypeName.put("android.os.Bundle", "Bundle");
        methodSuffixNameByTypeName.put("boolean", "Boolean");
        methodSuffixNameByTypeName.put("boolean[]", "BooleanArray");
        methodSuffixNameByTypeName.put("byte", "Byte");
        methodSuffixNameByTypeName.put("byte[]", "ByteArray");
        methodSuffixNameByTypeName.put("char", "Char");
        methodSuffixNameByTypeName.put("char[]", "CharArray");
        methodSuffixNameByTypeName.put(CanonicalNameConstants.CHAR_SEQUENCE, "CharSequence");
        methodSuffixNameByTypeName.put("double", "Double");
        methodSuffixNameByTypeName.put("double[]", "DoubleArray");
        methodSuffixNameByTypeName.put("float", "Float");
        methodSuffixNameByTypeName.put("float[]", "FloatArray");
        methodSuffixNameByTypeName.put("int", "Int");
        methodSuffixNameByTypeName.put("int[]", "IntArray");
        methodSuffixNameByTypeName.put("java.util.ArrayList<java.lang.Integer>", "IntegerArrayList");
        methodSuffixNameByTypeName.put("long", "Long");
        methodSuffixNameByTypeName.put("long[]", "LongArray");
        methodSuffixNameByTypeName.put("short", "Short");
        methodSuffixNameByTypeName.put("short[]", "ShortArray");
        methodSuffixNameByTypeName.put(CanonicalNameConstants.STRING, "String");
        methodSuffixNameByTypeName.put("java.lang.String[]", "StringArray");
        methodSuffixNameByTypeName.put("java.util.ArrayList<java.lang.String>", "StringArrayList");
    }
}

