/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.OptionsItem;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.SherlockHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class OptionsItemProcessor
implements DecoratingElementProcessor {
    private final IdAnnotationHelper helper;
    private final SherlockHelper sherlockHelper;

    public OptionsItemProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.sherlockHelper = new SherlockHelper(this.helper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return OptionsItem.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        EBeansHolder.Classes classes = holder.classes();
        String methodName = element.getSimpleName().toString();
        JClass menuItemClass = this.sherlockHelper.usesSherlock(holder) ? classes.SHERLOCK_MENU_ITEM : classes.MENU_ITEM;
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        TypeMirror returnType = executableElement.getReturnType();
        boolean returnMethodResult = returnType.getKind() != TypeKind.VOID;
        boolean hasItemParameter = parameters.size() == 1;
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        if (holder.onOptionsItemSelectedIfElseBlock == null) {
            JMethod method = holder.generatedClass.method(1, codeModel.BOOLEAN, "onOptionsItemSelected");
            method.annotate(Override.class);
            holder.onOptionsItemSelectedItem = method.param(menuItemClass, "item");
            JBlock body = method.body();
            JVar handled = body.decl(codeModel.BOOLEAN, "handled", JExpr.invoke(JExpr._super(), method).arg(holder.onOptionsItemSelectedItem));
            body._if(handled)._then()._return(JExpr.TRUE);
            holder.onOptionsItemSelectedItemId = body.decl(codeModel.INT, "itemId_", holder.onOptionsItemSelectedItem.invoke("getItemId"));
            holder.onOptionsItemSelectedIfElseBlock = body.block();
            body._return(JExpr.FALSE);
        }
        JExpression ifExpr = holder.onOptionsItemSelectedItemId.eq(idsRefs.get(0));
        for (int i = 1; i < idsRefs.size(); ++i) {
            ifExpr = ifExpr.cor(holder.onOptionsItemSelectedItemId.eq(idsRefs.get(i)));
        }
        JBlock itemIfBody = holder.onOptionsItemSelectedIfElseBlock._if(ifExpr)._then();
        JInvocation methodCall = JExpr.invoke(methodName);
        if (returnMethodResult) {
            itemIfBody._return(methodCall);
        } else {
            itemIfBody.add(methodCall);
            itemIfBody._return(JExpr.TRUE);
        }
        if (hasItemParameter) {
            methodCall.arg(holder.onOptionsItemSelectedItem);
        }
    }
}

