/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.annotations.EProvider;
import com.googlecode.androidannotations.helper.AndroidManifest;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

public class EProviderValidator
implements ElementValidator {
    private final ValidatorHelper validatorHelper;
    private final AndroidManifest androidManifest;

    public EProviderValidator(ProcessingEnvironment processingEnv, AndroidManifest androidManifest) {
        this.androidManifest = androidManifest;
        TargetAnnotationHelper annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
        this.validatorHelper = new ValidatorHelper(annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return EProvider.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.extendsProvider(element, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.validatorHelper.componentRegistered(element, this.androidManifest, valid);
        return valid.isValid();
    }
}

