/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation.rest;

import com.googlecode.androidannotations.annotations.rest.Delete;
import com.googlecode.androidannotations.helper.RestAnnotationHelper;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class DeleteValidator
implements ElementValidator {
    private ValidatorHelper validatorHelper;
    private RestAnnotationHelper restAnnotationHelper;

    public DeleteValidator(ProcessingEnvironment processingEnv) {
        TargetAnnotationHelper annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
        this.validatorHelper = new ValidatorHelper(annotationHelper);
        this.restAnnotationHelper = new RestAnnotationHelper(processingEnv, this.getTarget());
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Delete.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.notAlreadyValidated(element, validatedElements, valid);
        this.validatorHelper.enclosingElementHasRestAnnotation(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.throwsOnlyRestClientException(executableElement, valid);
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.restAnnotationHelper.urlVariableNamesExistInParametersAndHasNoOneMoreParameter(executableElement, valid);
        return valid.isValid();
    }
}

