/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.RunningLengthWord;

final class IntIteratorImpl
implements IntIterator {
    private final EWAHIterator ewahIter;
    private final long[] ewahBuffer;
    private int position;
    private int runningLength;
    private long word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;

    IntIteratorImpl(EWAHIterator ewahIter) {
        this.ewahIter = ewahIter;
        this.ewahBuffer = ewahIter.buffer();
    }

    public final boolean hasNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (!this.ewahIter.hasNext()) {
                return false;
            }
            this.setRunningLengthWord(this.ewahIter.next());
        }
        return true;
    }

    public final int next() {
        if (this.runningHasNext()) {
            return this.position++;
        }
        int bit = Long.numberOfTrailingZeros(this.word);
        this.word ^= 1L << bit;
        return this.literalPosition + bit;
    }

    private final void setRunningLengthWord(RunningLengthWord rlw) {
        this.runningLength = 64 * (int)rlw.getRunningLength() + this.position;
        if (!rlw.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = this.ewahIter.dirtyWords();
        this.wordLength = this.wordPosition + rlw.getNumberOfLiteralWords();
    }

    private final boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private final boolean literalHasNext() {
        while (this.word == 0L && this.wordPosition < this.wordLength) {
            this.word = this.ewahBuffer[this.wordPosition++];
            this.literalPosition = this.position;
            this.position += 64;
        }
        return this.word != 0L;
    }
}

