/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.annotation.GraphQLEnumType;
import com.graphql_java_generator.annotation.GraphQLInterfaceType;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLObjectType;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.annotation.GraphQLUnionType;
import com.graphql_java_generator.customscalars.CustomScalar;
import com.graphql_java_generator.customscalars.CustomScalarRegistryImpl;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class GraphqlClientUtils
extends GraphqlUtils {
    public static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    List<Class<?>> scalars = new ArrayList();

    public GraphqlClientUtils() {
        this.scalars.add(String.class);
        this.scalars.add(Integer.TYPE);
        this.scalars.add(Integer.class);
        this.scalars.add(Float.TYPE);
        this.scalars.add(Float.class);
        this.scalars.add(Boolean.TYPE);
        this.scalars.add(Boolean.class);
    }

    public void checkName(String graphqlIdentifier) throws GraphQLRequestPreparationException {
        if (graphqlIdentifier == null) {
            throw new NullPointerException("A GraphQL identifier may not be null");
        }
        Matcher m = this.graphqlNamePattern.matcher(graphqlIdentifier);
        if (!m.matches()) {
            throw new GraphQLRequestPreparationException("'" + graphqlIdentifier + "' is not a valid GraphQL name");
        }
    }

    public Class<?> checkIsScalar(Field field, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(field);
        if (shouldBeScalar != null) {
            if (shouldBeScalar & !isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the GraphQL type '" + field.getDeclaringClass().getName() + "' is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
            if (shouldBeScalar == false & isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the GraphQL type '" + field.getDeclaringClass().getName() + "' is not a GraphQLScalar. At least one field must be defined for the server response.");
            }
        }
        return this.getGraphQLType(field);
    }

    public Class<?> checkIsScalar(String fieldName, Method method, Boolean shouldBeScalar) throws GraphQLRequestPreparationException {
        boolean isScalar = this.isScalar(method);
        if (method.getReturnType() == null) {
            throw new GraphQLRequestPreparationException("There is a method of name '" + fieldName + "' in the GraphQL type '" + method.getDeclaringClass().getName() + "', but this method is a void method: it can't represent the '" + fieldName + "' GraphQL field");
        }
        if (shouldBeScalar != null) {
            if (shouldBeScalar.booleanValue() && !isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + fieldName + "' (accessed through its getter: " + method.getName() + "') of the GraphQL type '" + method.getDeclaringClass().getName() + "' should be a scalar. But is is actually not a GraphQLScalar");
            }
            if (!shouldBeScalar.booleanValue() && isScalar) {
                throw new GraphQLRequestPreparationException("The field '" + fieldName + "' (accessed through its getter: '" + method.getName() + "') of the GraphQL type '" + method.getDeclaringClass().getName() + "' should not be a scalar. But is is actually a GraphQLScalar");
            }
        }
        return this.getGraphQLType(method);
    }

    public boolean isScalar(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null || fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class) != null;
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the class '" + field.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method '" + method.getName() + "' of the class '" + method.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
    }

    public Class<?> getClass(String packageName, String graphQLTypeName, String schema) {
        CustomScalar customScalar;
        if ("Boolean".equals(graphQLTypeName) || "boolean".equals(graphQLTypeName)) {
            return Boolean.class;
        }
        if ("Integer".equals(graphQLTypeName) || "Int".equals(graphQLTypeName)) {
            return Integer.class;
        }
        if ("String".equals(graphQLTypeName) || "UUID".equals(graphQLTypeName)) {
            return String.class;
        }
        if ("Float".equals(graphQLTypeName) || "Double".equals(graphQLTypeName)) {
            return Double.class;
        }
        if (schema != null && (customScalar = CustomScalarRegistryImpl.getCustomScalarRegistry(schema).getCustomScalar(graphQLTypeName)) != null) {
            return customScalar.getValueClazz();
        }
        try {
            return (Class)((Object)((Object)this)).getClass().getClassLoader().loadClass(packageName + ".GraphQLTypeMapping").getMethod("getJavaClass", String.class).invoke(null, graphQLTypeName);
        }
        catch (ClassNotFoundException e) {
            String className = packageName + "." + GraphqlUtils.graphqlUtils.getJavaName(graphQLTypeName);
            try {
                return ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Could not load class '" + className + "' for type '" + graphQLTypeName + "'", e);
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not get the class for type '" + graphQLTypeName + "' from '" + packageName + ".GraphQLTypeMapping" + "'", e);
        }
    }

    public Field getDeclaredField(Class<?> owningClass, String fieldName, boolean mustFindField) throws GraphQLRequestPreparationException {
        try {
            return owningClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e1) {
            block6: {
                if (owningClass.getSimpleName().endsWith("Response")) {
                    try {
                        return owningClass.getSuperclass().getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException | SecurityException e2) {
                        if (!mustFindField) break block6;
                        throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName() + ", nor in " + owningClass.getSuperclass().getName(), (Throwable)e1);
                    }
                }
            }
            if (mustFindField) {
                throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName(), (Throwable)e1);
            }
            return null;
        }
    }

    public Class<?> getFieldType(Class<?> owningClass, String fieldName, boolean returnIsMandatory) throws GraphQLRequestPreparationException {
        if (owningClass.isInterface()) {
            try {
                Method method = owningClass.getDeclaredMethod("get" + graphqlUtils.getPascalCase(fieldName), new Class[0]);
                GraphQLNonScalar graphQLNonScalar = method.getAnnotation(GraphQLNonScalar.class);
                GraphQLScalar graphQLScalar = method.getAnnotation(GraphQLScalar.class);
                if (graphQLNonScalar != null) {
                    return graphQLNonScalar.javaClass();
                }
                if (graphQLScalar != null) {
                    return graphQLScalar.javaClass();
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the interface '" + owningClass.getName() + "': this method should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
            }
            catch (NoSuchMethodException e) {
                if (!returnIsMandatory) {
                    return null;
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", (Throwable)e);
            }
            catch (SecurityException e) {
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", (Throwable)e);
            }
        }
        try {
            Field field = owningClass.getDeclaredField(graphqlUtils.getJavaName(fieldName));
            GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
            GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
            if (graphQLNonScalar != null) {
                return graphQLNonScalar.javaClass();
            }
            if (graphQLScalar != null) {
                return graphQLScalar.javaClass();
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "': this field should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
        }
        catch (NoSuchFieldException e) {
            if (!returnIsMandatory) {
                return null;
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new GraphQLRequestPreparationException("Error while looking for the the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", (Throwable)e);
        }
    }

    public Class<?> getGraphQLType(AccessibleObject fieldOrMethod) throws GraphQLRequestPreparationException {
        if (fieldOrMethod.getAnnotation(GraphQLScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLScalar.class).javaClass();
        }
        if (fieldOrMethod.getAnnotation(GraphQLNonScalar.class) != null) {
            return fieldOrMethod.getAnnotation(GraphQLNonScalar.class).javaClass();
        }
        if (fieldOrMethod instanceof Field) {
            Field field = (Field)fieldOrMethod;
            throw new GraphQLRequestPreparationException("The field '" + field.getName() + "' of the class '" + field.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
        }
        Method method = (Method)fieldOrMethod;
        throw new GraphQLRequestPreparationException("The method '" + method.getName() + "' of the class '" + method.getDeclaringClass().getName() + "' has none of the GraphQLCustomScalar, GraphQLScalar or GraphQLNonScalar annotation");
    }

    public Class<?> checkFieldOfGraphQLType(String name, Boolean shouldBeScalar, Class<?> owningClass) throws GraphQLRequestPreparationException {
        this.checkName(name);
        Class<?> fieldClass = null;
        Field field = this.getDeclaredField(owningClass, graphqlUtils.getJavaName(name), false);
        if (field != null) {
            fieldClass = this.checkIsScalar(field, shouldBeScalar);
        }
        if (fieldClass == null && !owningClass.isInterface()) {
            for (Method method : owningClass.getMethods()) {
                if (!method.getName().equals(name)) continue;
                fieldClass = this.checkIsScalar(name, method, shouldBeScalar);
                break;
            }
        }
        if (fieldClass == null && owningClass.isInterface()) {
            String expectedMethodName = "get" + graphqlUtils.getPascalCase(name);
            for (Method method : owningClass.getDeclaredMethods()) {
                if (!method.getName().equals(expectedMethodName)) continue;
                fieldClass = this.checkIsScalar(name, method, shouldBeScalar);
                break;
            }
        }
        if (fieldClass == null) {
            throw new GraphQLRequestPreparationException("The GraphQL type '" + owningClass.getSimpleName() + "' (" + owningClass.getName() + ") has no field of name '" + name + "'");
        }
        return fieldClass;
    }

    public Map<String, Object> generatesBindVariableValuesMap(Object[] paramsAndValues) throws GraphQLRequestExecutionException, ClassCastException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (paramsAndValues != null) {
            if (paramsAndValues.length % 2 != 0) {
                throw new GraphQLRequestExecutionException("An even number of parameters is expected, but " + paramsAndValues.length + " parameters where sent. This method expects a series of name and values : (paramName1, paramValue1, paramName2, paramValue2...)");
            }
            for (int i = 0; i < paramsAndValues.length; i += 2) {
                map.put((String)paramsAndValues[i], paramsAndValues[i + 1]);
            }
        }
        return map;
    }

    public Object parseValueForInputParameter(Object parameterValue, String parameterType, Class<?> parameterClass, String schema) {
        GraphQLScalarType graphQLScalarType = CustomScalarRegistryImpl.getCustomScalarRegistry(schema).getGraphQLCustomScalarType(parameterType);
        if (graphQLScalarType != null) {
            return graphQLScalarType.getCoercing().parseValue(parameterValue);
        }
        if (parameterType.equals("Boolean")) {
            if (parameterValue instanceof Boolean) {
                return parameterValue;
            }
            if (parameterValue instanceof String) {
                if (parameterValue.equals("true")) {
                    return Boolean.TRUE;
                }
                if (parameterValue.equals("false")) {
                    return Boolean.FALSE;
                }
            }
            throw new RuntimeException("Bad boolean value '" + parameterValue + "' for the parameter type '" + parameterType + "'");
        }
        if (parameterType.equals("Float")) {
            return Double.parseDouble((String)parameterValue);
        }
        if (parameterType.equals("Int")) {
            return Integer.parseInt((String)parameterValue);
        }
        if (parameterType.equals("Long")) {
            return Long.parseLong((String)parameterValue);
        }
        if (parameterType.equals("String")) {
            return parameterValue;
        }
        if (parameterClass.isEnum()) {
            Method valueOf = graphqlUtils.getMethod("valueOf", parameterClass, new Class[]{String.class});
            return graphqlUtils.invokeMethod(valueOf, null, new Object[]{parameterValue});
        }
        if (parameterClass.isAssignableFrom(Boolean.class)) {
            if (!"true".equals(parameterValue) && !"false".equals(parameterValue)) {
                throw new RuntimeException("Only true and false are allowed values for booleans, but the value is '" + parameterValue + "'");
            }
            return "true".equals(parameterValue);
        }
        if (parameterClass.isAssignableFrom(Integer.class)) {
            return Integer.parseInt((String)parameterValue);
        }
        if (parameterClass.isAssignableFrom(Float.class)) {
            return Float.valueOf(Float.parseFloat((String)parameterValue));
        }
        throw new RuntimeException("Couldn't parse the value'" + parameterValue + "' for the parameter type '" + parameterType + "': non managed GraphQL type (maybe a custom scalar is not properly registered?)");
    }

    public String getGraphQLTypeNameFromClass(Class<?> clazz) {
        GraphQLObjectType graphQLObjectType = clazz.getAnnotation(GraphQLObjectType.class);
        if (graphQLObjectType != null) {
            return graphQLObjectType.value();
        }
        GraphQLInterfaceType graphQLInterfaceType = clazz.getAnnotation(GraphQLInterfaceType.class);
        if (graphQLInterfaceType != null) {
            return graphQLInterfaceType.value();
        }
        GraphQLUnionType graphQLUnionType = clazz.getAnnotation(GraphQLUnionType.class);
        if (graphQLUnionType != null) {
            return graphQLUnionType.value();
        }
        GraphQLEnumType graphQLEnumType = clazz.getAnnotation(GraphQLEnumType.class);
        if (graphQLEnumType != null) {
            return graphQLEnumType.value();
        }
        throw new RuntimeException("Could not find the GraphQL type for the class " + clazz.getName());
    }

    public GraphQLScalarType getGraphQLCustomScalarType(AccessibleObject fieldOrMethod, String schema) {
        String graphQLTypeName = fieldOrMethod.getAnnotation(GraphQLScalar.class) != null ? fieldOrMethod.getAnnotation(GraphQLScalar.class).graphQLTypeSimpleName() : null;
        if (graphQLTypeName != null) {
            return CustomScalarRegistryImpl.getCustomScalarRegistry(schema).getGraphQLCustomScalarType(graphQLTypeName);
        }
        return null;
    }

    public GraphQLScalarType getGraphQLScalarTypeFromName(String typeName, String schema) {
        if (typeName.equals("String")) {
            return Scalars.GraphQLString;
        }
        if (typeName.equals("Boolean")) {
            return Scalars.GraphQLBoolean;
        }
        if (typeName.equals("Float")) {
            return Scalars.GraphQLFloat;
        }
        if (typeName.equals("Int")) {
            return Scalars.GraphQLInt;
        }
        if (typeName.equals("ID")) {
            return Scalars.GraphQLID;
        }
        return CustomScalarRegistryImpl.getCustomScalarRegistry(schema).getGraphQLCustomScalarType(typeName);
    }
}

