/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.QueryExecutor;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ObjectResponse {
    private static Logger logger = LoggerFactory.getLogger(ObjectResponse.class);
    private static GraphqlClientUtils graphqlClientUtils = new GraphqlClientUtils();
    Marker marker = QueryExecutor.GRAPHQL_MARKER;
    final Field field;
    List<Field> scalarFields = new ArrayList<Field>();
    List<ObjectResponse> subObjects = new ArrayList<ObjectResponse>();

    ObjectResponse(Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        this(owningClass, fieldName, null);
    }

    ObjectResponse(Class<?> owningClass, String fieldName, String fieldAlias) throws GraphQLRequestPreparationException {
        this.field = new Field(fieldName, fieldAlias, owningClass, graphqlClientUtils.checkFieldOfGraphQLType(fieldName, false, owningClass), null);
    }

    public String getFieldAlias() {
        return this.field.alias;
    }

    public Class<?> getOwningClass() {
        return this.field.owningClass;
    }

    public Class<?> getFieldClass() {
        return this.field.clazz;
    }

    public String getFieldName() {
        return this.field.name;
    }

    public List<InputParameter> getInputParameters() {
        return this.field.inputParameters;
    }

    public void appendResponseQuery(StringBuilder sb, Map<String, Object> parameters, boolean appendSpaceParam) throws GraphQLRequestExecutionException {
        this.appendFieldName(sb, appendSpaceParam, this.getFieldName(), this.getFieldAlias());
        this.appendInputParameters(sb, this.getInputParameters(), parameters);
        boolean appendSpaceLocal = false;
        if (this.scalarFields.size() > 0 || this.subObjects.size() > 0) {
            logger.debug("Appending ReponseDef content for field " + this.field.name + " of type " + this.field.clazz);
            sb.append("{");
            for (Field f : this.scalarFields) {
                this.appendFieldName(sb, appendSpaceLocal, f.name, f.alias);
                this.appendInputParameters(sb, f.inputParameters, parameters);
                appendSpaceLocal = true;
            }
            for (ObjectResponse o : this.subObjects) {
                o.appendResponseQuery(sb, parameters, appendSpaceLocal);
                appendSpaceLocal = true;
            }
            sb.append("}");
        }
    }

    private void appendInputParameters(StringBuilder sb, List<InputParameter> inputParameters, Map<String, Object> parameters) throws GraphQLRequestExecutionException {
        if (inputParameters != null && inputParameters.size() > 0) {
            ArrayList<String> params = new ArrayList<String>();
            for (InputParameter param : inputParameters) {
                String stringValue = param.getValueForGraphqlQuery(parameters);
                if (stringValue == null) continue;
                params.add(param.getName() + ":" + stringValue);
            }
            if (params.size() > 0) {
                sb.append("(");
                boolean writeComma = false;
                for (String param : params) {
                    if (writeComma) {
                        sb.append(", ");
                    }
                    writeComma = true;
                    sb.append(param);
                }
                sb.append(")");
            }
        }
    }

    void appendFieldName(StringBuilder sb, boolean appendSpace, String name, String alias) {
        if (appendSpace) {
            sb.append(" ");
        }
        if (alias != null) {
            sb.append(alias).append(":");
        }
        sb.append(name);
    }

    public void addInputParameter(InputParameter inputParameter) {
        this.field.inputParameters.add(inputParameter);
    }

    public void addInputParameters(List<InputParameter> inputParameters) {
        this.field.inputParameters.addAll(inputParameters);
    }

    static class Field {
        final String name;
        final String alias;
        final Class<?> owningClass;
        final Class<?> clazz;
        final List<InputParameter> inputParameters;

        Field(String name, String alias, Class<?> owningClass, Class<?> clazz, List<InputParameter> inputParameters) throws GraphQLRequestPreparationException {
            graphqlClientUtils.checkName(name);
            if (alias != null) {
                graphqlClientUtils.checkName(alias);
            }
            this.name = name;
            this.alias = alias;
            this.owningClass = owningClass;
            this.clazz = clazz;
            this.inputParameters = inputParameters == null ? new ArrayList() : inputParameters;
        }
    }
}

