/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.server.util;

import com.graphql_java_generator.annotation.GraphQLEnumType;
import com.graphql_java_generator.annotation.GraphQLInterfaceType;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLObjectType;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.annotation.GraphQLUnionType;
import com.graphql_java_generator.util.GraphqlUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class GraphqlServerUtils {
    public static GraphqlServerUtils graphqlServerUtils = new GraphqlServerUtils();
    private static GraphqlUtils graphqlUtils = new GraphqlUtils();

    public String classNameExtractor(Class<?> cls) {
        GraphQLEnumType graphQLEnumType = cls.getAnnotation(GraphQLEnumType.class);
        if (graphQLEnumType != null) {
            return graphQLEnumType.value();
        }
        GraphQLInterfaceType graphQLInterfaceType = cls.getAnnotation(GraphQLInterfaceType.class);
        if (graphQLInterfaceType != null) {
            return graphQLInterfaceType.value();
        }
        GraphQLObjectType graphQLObjectType = cls.getAnnotation(GraphQLObjectType.class);
        if (graphQLObjectType != null) {
            return graphQLObjectType.value();
        }
        GraphQLUnionType graphQLUnionType = cls.getAnnotation(GraphQLUnionType.class);
        if (graphQLUnionType != null) {
            return graphQLUnionType.value();
        }
        return cls.getSimpleName();
    }

    public Object getArgument(Object jsonParsedValue, String graphQLTypeName, String javaTypeForIDType, Class<?> clazz) {
        if (jsonParsedValue == null) {
            return null;
        }
        if (jsonParsedValue instanceof List) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Object o : (List)jsonParsedValue) {
                objects.add(this.getArgument(o, graphQLTypeName, javaTypeForIDType, clazz));
            }
            return objects;
        }
        if (jsonParsedValue instanceof Map) {
            Object t;
            Map map = (Map)jsonParsedValue;
            try {
                t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error while creating a new instance of  '" + clazz.getName() + " class", e);
            }
            for (String key : map.keySet()) {
                Object value;
                GraphQLScalar graphQLScalar = null;
                GraphQLNonScalar graphQLNonScalar = null;
                Method setter = null;
                for (Field field : clazz.getDeclaredFields()) {
                    graphQLScalar = field.getAnnotation(GraphQLScalar.class);
                    graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
                    if ((graphQLScalar == null || !graphQLScalar.fieldName().equals(key)) && (graphQLNonScalar == null || !graphQLNonScalar.fieldName().equals(key))) continue;
                    setter = graphqlUtils.getSetter(clazz, field);
                    break;
                }
                if (graphQLScalar == null && graphQLNonScalar == null) {
                    throw new RuntimeException("Found no GraphQL field of name '" + key + "' in class " + clazz.getName());
                }
                if (graphQLScalar != null) {
                    value = this.getArgument(map.get(key), graphQLScalar.graphQLTypeSimpleName(), javaTypeForIDType, graphQLScalar.javaClass());
                } else if (graphQLNonScalar != null) {
                    value = this.getArgument(map.get(key), graphQLNonScalar.graphQLTypeSimpleName(), javaTypeForIDType, graphQLNonScalar.javaClass());
                } else {
                    throw new RuntimeException("Internal error: the field '" + clazz.getName() + "." + key + "' should have one of these annotations: GraphQLScalar or GraphQLScalar");
                }
                graphqlUtils.invokeMethod(setter, t, new Object[]{value});
            }
            return t;
        }
        if (clazz.isEnum()) {
            if (!(jsonParsedValue instanceof String)) {
                throw new RuntimeException("The " + clazz.getName() + " class is an enum, but the provided value is '" + jsonParsedValue + "' which should be a String, to be mapped to the relevant enum value");
            }
            Method fromGraphQlValue = graphqlUtils.getMethod("fromGraphQlValue", clazz, new Class[]{String.class});
            return graphqlUtils.invokeMethod(fromGraphQlValue, null, new Object[]{(String)jsonParsedValue});
        }
        if (graphQLTypeName.equals("ID")) {
            if (javaTypeForIDType == null || javaTypeForIDType.equals("")) {
                return UUID.fromString((String)jsonParsedValue);
            }
            if (javaTypeForIDType.equals("java.util.UUID")) {
                return UUID.fromString((String)jsonParsedValue);
            }
            if (javaTypeForIDType.equals("java.lang.String")) {
                return jsonParsedValue;
            }
            if (javaTypeForIDType.equals("java.lang.Long")) {
                return Long.parseLong((String)jsonParsedValue);
            }
            throw new RuntimeException("Non managed value for the plugin parameter 'javaTypeForIDType': '" + javaTypeForIDType + "'");
        }
        if (clazz.isInstance(jsonParsedValue)) {
            return jsonParsedValue;
        }
        if (jsonParsedValue instanceof String) {
            if (clazz == String.class) {
                return jsonParsedValue;
            }
            if (clazz == UUID.class) {
                return UUID.fromString((String)jsonParsedValue);
            }
            if (clazz == Boolean.class) {
                return jsonParsedValue.equals("true");
            }
            if (clazz == Long.class) {
                return Long.parseLong((String)jsonParsedValue);
            }
            if (clazz == Integer.class) {
                return Integer.parseInt((String)jsonParsedValue);
            }
            if (clazz == Double.class) {
                return Double.parseDouble((String)jsonParsedValue);
            }
            if (clazz == Float.class) {
                return Float.valueOf(Float.parseFloat((String)jsonParsedValue));
            }
        }
        throw new RuntimeException("Can't transform the jsonParsedValue (" + jsonParsedValue.getClass().getName() + ") into a " + clazz.getName());
    }

    public Object enumValueToString(Object enumValue) {
        if (enumValue == null) {
            return null;
        }
        if (enumValue instanceof Optional && !((Optional)enumValue).isPresent()) {
            return Optional.empty();
        }
        if (enumValue instanceof Optional && ((Optional)enumValue).isPresent()) {
            return Optional.of(this.enumValueToString(((Optional)enumValue).get()));
        }
        if (enumValue instanceof List) {
            return ((List)enumValue).stream().map(v -> this.enumValueToString(v)).collect(Collectors.toList());
        }
        if (enumValue instanceof Flux) {
            return ((Flux)enumValue).map(v -> this.enumValueToString(v));
        }
        Method method = null;
        try {
            method = enumValue.getClass().getMethod("graphQlValue", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("The given value may be either null, an Optional, a List or an enum that has the 'graphQlValue' method'", e);
        }
        try {
            return method.invoke(enumValue, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

