/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.PublicSpi;
import graphql.TypeResolutionEnvironment;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionParameters;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.TypeInfo;
import graphql.execution.TypeResolutionParameters;
import graphql.execution.ValuesResolver;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.FieldFetchParameters;
import graphql.execution.instrumentation.parameters.FieldParameters;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    protected final ValuesResolver valuesResolver = new ValuesResolver();
    protected final FieldCollector fieldCollector = new FieldCollector();

    public abstract ExecutionResult execute(ExecutionContext var1, ExecutionParameters var2) throws NonNullableFieldWasNullException;

    protected void handleDataFetchingException(ExecutionContext executionContext, GraphQLFieldDefinition fieldDef, Map<String, Object> argumentValues, Exception e) {
        executionContext.addError((GraphQLError)new ExceptionWhileDataFetching((Throwable)e));
    }

    protected ExecutionResult resolveField(ExecutionContext executionContext, ExecutionParameters parameters, List<Field> fields) {
        GraphQLObjectType type = parameters.typeInfo().castType(GraphQLObjectType.class);
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), type, fields.get(0));
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldDef.getArguments(), fields.get(0).getArguments(), executionContext.getVariables());
        GraphQLOutputType fieldType = fieldDef.getType();
        DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector((ExecutionContext)executionContext, (GraphQLType)fieldType, fields);
        DataFetchingEnvironmentImpl environment = new DataFetchingEnvironmentImpl(parameters.source(), argumentValues, executionContext.getRoot(), fields, fieldType, (GraphQLType)type, executionContext.getGraphQLSchema(), executionContext.getFragmentsByName(), executionContext.getExecutionId(), fieldCollector);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext fieldCtx = instrumentation.beginField(new FieldParameters(executionContext, fieldDef, (DataFetchingEnvironment)environment));
        InstrumentationContext fetchCtx = instrumentation.beginFieldFetch(new FieldFetchParameters(executionContext, fieldDef, (DataFetchingEnvironment)environment));
        Object resolvedValue = null;
        try {
            resolvedValue = fieldDef.getDataFetcher().get((DataFetchingEnvironment)environment);
            fetchCtx.onEnd(resolvedValue);
        }
        catch (Exception e) {
            log.warn("Exception while fetching data", (Throwable)e);
            this.handleDataFetchingException(executionContext, fieldDef, argumentValues, e);
            fetchCtx.onEnd(e);
        }
        TypeInfo fieldTypeInfo = TypeInfo.newTypeInfo().type((GraphQLType)fieldType).parentInfo(parameters.typeInfo()).build();
        ExecutionParameters newParameters = ExecutionParameters.newParameters().typeInfo(fieldTypeInfo).fields(parameters.fields()).arguments(argumentValues).source(resolvedValue).build();
        ExecutionResult result = this.completeValue(executionContext, newParameters, fields);
        fieldCtx.onEnd((Object)result);
        return result;
    }

    protected ExecutionResult completeValue(ExecutionContext executionContext, ExecutionParameters parameters, List<Field> fields) {
        GraphQLObjectType resolvedType;
        TypeResolutionParameters resolutionParams;
        TypeInfo typeInfo = parameters.typeInfo();
        Object result = parameters.source();
        GraphQLType fieldType = parameters.typeInfo().type();
        if (result == null) {
            if (typeInfo.typeIsNonNull()) {
                NonNullableFieldWasNullException nonNullException = new NonNullableFieldWasNullException(typeInfo);
                executionContext.addError(nonNullException);
                throw nonNullException;
            }
            return null;
        }
        if (fieldType instanceof GraphQLList) {
            return this.completeValueForList(executionContext, parameters, fields, this.toIterable(result));
        }
        if (fieldType instanceof GraphQLScalarType) {
            return this.completeValueForScalar((GraphQLScalarType)fieldType, result);
        }
        if (fieldType instanceof GraphQLEnumType) {
            return this.completeValueForEnum((GraphQLEnumType)fieldType, result);
        }
        if (fieldType instanceof GraphQLInterfaceType) {
            resolutionParams = TypeResolutionParameters.newParameters().graphQLInterfaceType((GraphQLInterfaceType)fieldType).field(fields.get(0)).value(parameters.source()).argumentValues(parameters.arguments()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForInterface(resolutionParams);
        } else if (fieldType instanceof GraphQLUnionType) {
            resolutionParams = TypeResolutionParameters.newParameters().graphQLUnionType((GraphQLUnionType)fieldType).field(fields.get(0)).value(parameters.source()).argumentValues(parameters.arguments()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForUnion(resolutionParams);
        } else {
            resolvedType = (GraphQLObjectType)fieldType;
        }
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters(executionContext.getGraphQLSchema(), resolvedType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        Map<String, List<Field>> subFields = this.fieldCollector.collectFields(collectorParameters, fields);
        ExecutionParameters newParameters = ExecutionParameters.newParameters().typeInfo(typeInfo.asType((GraphQLType)resolvedType)).fields(subFields).source(result).build();
        return executionContext.getQueryStrategy().execute(executionContext, newParameters);
    }

    private Iterable<Object> toIterable(Object result) {
        if (result.getClass().isArray()) {
            result = Arrays.asList((Object[])result);
        }
        return result;
    }

    protected GraphQLObjectType resolveTypeForInterface(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), (GraphQLType)params.getGraphQLInterfaceType(), params.getSchema());
        GraphQLObjectType result = params.getGraphQLInterfaceType().getTypeResolver().getType(env);
        if (result == null) {
            throw new GraphQLException("Could not determine the exact type of " + params.getGraphQLInterfaceType().getName());
        }
        return result;
    }

    protected GraphQLObjectType resolveTypeForUnion(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), (GraphQLType)params.getGraphQLUnionType(), params.getSchema());
        GraphQLObjectType result = params.getGraphQLUnionType().getTypeResolver().getType(env);
        if (result == null) {
            throw new GraphQLException("Could not determine the exact type of " + params.getGraphQLUnionType().getName());
        }
        return result;
    }

    protected ExecutionResult completeValueForEnum(GraphQLEnumType enumType, Object result) {
        return new ExecutionResultImpl(enumType.getCoercing().serialize(result), null);
    }

    protected ExecutionResult completeValueForScalar(GraphQLScalarType scalarType, Object result) {
        Object serialized = scalarType.getCoercing().serialize(result);
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            serialized = null;
        }
        return new ExecutionResultImpl(serialized, null);
    }

    protected ExecutionResult completeValueForList(ExecutionContext executionContext, ExecutionParameters parameters, List<Field> fields, Iterable<Object> result) {
        ArrayList<Object> completedResults = new ArrayList<Object>();
        TypeInfo typeInfo = parameters.typeInfo();
        GraphQLList fieldType = typeInfo.castType(GraphQLList.class);
        for (Object item : result) {
            ExecutionParameters newParameters = ExecutionParameters.newParameters().typeInfo(typeInfo.asType(fieldType.getWrappedType())).fields(parameters.fields()).source(item).build();
            ExecutionResult completedValue = this.completeValue(executionContext, newParameters, fields);
            completedResults.add(completedValue != null ? completedValue.getData() : null);
        }
        return new ExecutionResultImpl(completedResults, null);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        if (schema.getQueryType() == parentType) {
            if (field.getName().equals(Introspection.SchemaMetaFieldDef.getName())) {
                return Introspection.SchemaMetaFieldDef;
            }
            if (field.getName().equals(Introspection.TypeMetaFieldDef.getName())) {
                return Introspection.TypeMetaFieldDef;
            }
        }
        if (field.getName().equals(Introspection.TypeNameMetaFieldDef.getName())) {
            return Introspection.TypeNameMetaFieldDef;
        }
        GraphQLFieldDefinition fieldDefinition = parentType.getFieldDefinition(field.getName());
        if (fieldDefinition == null) {
            throw new GraphQLException("Unknown field " + field.getName());
        }
        return fieldDefinition;
    }
}

