/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodev.graphql.tools;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.coxautodev.graphql.tools.InvalidSchemaError;
import com.coxautodev.graphql.tools.SchemaClassScanner;
import com.coxautodev.graphql.tools.SchemaParser;
import com.coxautodev.graphql.tools.SchemaParserDictionary;
import com.coxautodev.graphql.tools.SchemaParserOptions;
import com.google.common.collect.BiMap;
import graphql.language.Document;
import graphql.parser.Parser;
import graphql.schema.GraphQLScalarType;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0002\u001a\u00020\u00002\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J'\u0010\u0002\u001a\u00020\u00002\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00120\u0013\"\u0006\u0012\u0002\b\u00030\u0012\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u0018\u0010\u0002\u001a\u00020\u00002\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0017J\u001e\u0010\u0002\u001a\u00020\u00002\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0016J\u001f\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0013\"\u00020\u0016\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J'\u0010\u0007\u001a\u00020\u00002\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\u0013\"\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u0007\u001a\u00020\u00002\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0017J\u001f\u0010\n\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0013\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/coxautodev/graphql/tools/SchemaParserBuilder;", "", "dictionary", "Lcom/coxautodev/graphql/tools/SchemaParserDictionary;", "(Lcom/coxautodev/graphql/tools/SchemaParserDictionary;)V", "options", "Lcom/coxautodev/graphql/tools/SchemaParserOptions;", "resolvers", "", "Lcom/coxautodev/graphql/tools/GraphQLResolver;", "scalars", "Lgraphql/schema/GraphQLScalarType;", "schemaString", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "build", "Lcom/coxautodev/graphql/tools/SchemaParser;", "clazz", "Ljava/lang/Class;", "", "([Ljava/lang/Class;)Lcom/coxautodev/graphql/tools/SchemaParserBuilder;", "name", "", "", "", "file", "filename", "files", "([Ljava/lang/String;)Lcom/coxautodev/graphql/tools/SchemaParserBuilder;", "([Lcom/coxautodev/graphql/tools/GraphQLResolver;)Lcom/coxautodev/graphql/tools/SchemaParserBuilder;", "([Lgraphql/schema/GraphQLScalarType;)Lcom/coxautodev/graphql/tools/SchemaParserBuilder;", "string", "graphql-java-tools"})
public final class SchemaParserBuilder {
    private final StringBuilder schemaString;
    private final List<GraphQLResolver<?>> resolvers;
    private final List<GraphQLScalarType> scalars;
    private SchemaParserOptions options;
    private final SchemaParserDictionary dictionary;

    @NotNull
    public final SchemaParserBuilder files(String ... files) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull((Object)files, (String)"files");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        Object[] $receiver$iv = files;
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            String it = (String)element$iv;
            $receiver.file(it);
        }
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder file(@NotNull String filename) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        InputStream inputStream = new Object(){}.getClass().getClassLoader().getResourceAsStream(filename);
        if (inputStream == null) {
            throw (Throwable)new FileNotFoundException("classpath:" + filename);
        }
        $receiver.schemaString(TextStreamsKt.readText((Reader)new BufferedReader(new InputStreamReader(inputStream))));
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder schemaString(@NotNull String string) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.schemaString.append("\n").append(string);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder resolvers(GraphQLResolver<?> ... resolvers) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull(resolvers, (String)"resolvers");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        CollectionsKt.addAll((Collection)$receiver.resolvers, (Object[])resolvers);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder resolvers(@NotNull List<? extends GraphQLResolver<?>> resolvers) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull(resolvers, (String)"resolvers");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.resolvers.addAll((Collection)resolvers);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder scalars(GraphQLScalarType ... scalars) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull((Object)scalars, (String)"scalars");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        CollectionsKt.addAll((Collection)$receiver.scalars, (Object[])scalars);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder dictionary(@NotNull String name, @NotNull Class<?> clazz) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.dictionary.add(name, clazz);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder dictionary(@NotNull Map<String, ? extends Class<?>> dictionary) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull(dictionary, (String)"dictionary");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.dictionary.add(dictionary);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder dictionary(@NotNull Class<?> clazz) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.dictionary.add(clazz);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder dictionary(Class<?> ... dictionary) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull(dictionary, (String)"dictionary");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.dictionary.add(Arrays.copyOf(dictionary, dictionary.length));
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder dictionary(@NotNull List<? extends Class<?>> dictionary) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull(dictionary, (String)"dictionary");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.dictionary.add(dictionary);
        return schemaParserBuilder;
    }

    @NotNull
    public final SchemaParserBuilder options(@NotNull SchemaParserOptions options) {
        SchemaParserBuilder schemaParserBuilder;
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        SchemaParserBuilder $receiver = schemaParserBuilder = this;
        $receiver.options = options;
        return schemaParserBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SchemaParser build() {
        void $receiver$iv$iv;
        Document document;
        try {
            document = new Parser().parseDocument(this.schemaString.toString());
        }
        catch (ParseCancellationException pce) {
            Throwable cause = pce.getCause();
            if (cause != null && cause instanceof RecognitionException) {
                throw (Throwable)new InvalidSchemaError(pce, (RecognitionException)cause);
            }
            throw (Throwable)pce;
        }
        Document document2 = document;
        List definitions = document2.getDefinitions();
        Iterable $receiver$iv = this.scalars;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            GraphQLScalarType graphQLScalarType = (GraphQLScalarType)element$iv$iv;
            Map map = destination$iv$iv;
            String string = it.getName();
            map.put(string, element$iv$iv);
        }
        Map customScalars = destination$iv$iv;
        BiMap<String, Class<?>> biMap = this.dictionary.getDictionary();
        List list = definitions;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"definitions");
        return new SchemaClassScanner(biMap, list, this.resolvers, customScalars, this.options).scanForClasses();
    }

    public SchemaParserBuilder(@NotNull SchemaParserDictionary dictionary) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)dictionary, (String)"dictionary");
        this.dictionary = dictionary;
        this.schemaString = new StringBuilder();
        SchemaParserBuilder schemaParserBuilder = this;
        schemaParserBuilder.resolvers = list = (List)new ArrayList();
        schemaParserBuilder = this;
        schemaParserBuilder.scalars = list = (List)new ArrayList();
        this.options = SchemaParserOptions.Companion.defaultOptions();
    }

    public /* synthetic */ SchemaParserBuilder(SchemaParserDictionary schemaParserDictionary, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            schemaParserDictionary = new SchemaParserDictionary();
        }
        this(schemaParserDictionary);
    }

    public SchemaParserBuilder() {
        this(null, 1, null);
    }
}

